/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.fs;

import com.gigaspaces.security.Authority;
import com.gigaspaces.security.authorities.PopulatedRoleAuthority;
import com.gigaspaces.security.authorities.RoleAuthority;
import com.gigaspaces.security.directory.RoleDataAccessException;
import com.gigaspaces.security.directory.RoleDetails;
import com.gigaspaces.security.directory.RoleNotFoundException;
import com.gigaspaces.security.directory.User;
import com.gigaspaces.security.directory.UserDataAccessException;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.security.directory.UserNotFoundException;
import com.gigaspaces.security.encoding.ContentEncoder;
import com.gigaspaces.security.fs.FileContent;
import com.gigaspaces.security.fs.FileEncodingManager;
import com.gigaspaces.security.fs.FileService;
import java.io.IOException;
import java.util.ArrayList;

public class FileServiceAccessor {
    private final FileService fileService;
    private final FileEncodingManager fileEncodingManager;
    private FileContent fileContent;
    private long lastModified = -1L;

    public FileServiceAccessor(FileService fileService, FileEncodingManager fileEncodingManager) throws IOException {
        this.fileService = fileService;
        this.fileEncodingManager = fileEncodingManager;
        this.refreshCache();
    }

    private void refreshCache() throws IOException {
        if (!this.fileService.fileExists()) {
            this.fileContent = new FileContent();
        } else {
            byte[] bytes = this.fileService.readFromFile();
            ContentEncoder contentEncoder = this.fileEncodingManager.getContentEncoder();
            Object decoded = contentEncoder.decode(bytes);
            this.fileContent = (FileContent)decoded;
            this.lastModified = this.fileService.lastModified();
        }
    }

    private boolean cacheNeedsRefresh() {
        long fileLastModified = this.fileService.lastModified();
        if (fileLastModified == -1L) {
            return true;
        }
        return fileLastModified != this.lastModified;
    }

    public UserDetails loadUserByUsername(String username) throws UserNotFoundException, UserDataAccessException, RoleNotFoundException, RoleDataAccessException, IOException {
        UserDetails userDetails;
        if (this.cacheNeedsRefresh()) {
            this.refreshCache();
        }
        if ((userDetails = this.fileContent.getUserDetails().get(username)) == null) {
            throw new UserNotFoundException("Could not find user: " + username);
        }
        User user = this.populateWithAuthorities(userDetails);
        return user;
    }

    private User populateWithAuthorities(UserDetails userDetails) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Authority authority : userDetails.getAuthorities()) {
            if (authority instanceof RoleAuthority) {
                String rolename = ((RoleAuthority)authority).getRole();
                RoleDetails roleDetails = this.fileContent.getRoleDetails().get(rolename);
                if (roleDetails == null) {
                    throw new RoleNotFoundException("Could not find role: " + rolename);
                }
                Authority[] roleAuthorities = roleDetails.getAuthorities();
                PopulatedRoleAuthority populatedRoleAuthority = new PopulatedRoleAuthority(rolename, roleAuthorities);
                list.add(populatedRoleAuthority);
                continue;
            }
            list.add(authority);
        }
        Authority[] authorities = list.toArray(new Authority[list.size()]);
        User user = new User(userDetails.getUsername(), userDetails.getPassword(), authorities);
        return user;
    }

    public void close() throws IOException {
        if (this.fileContent.isModified()) {
            byte[] bytes = this.fileEncodingManager.getContentEncoder().encode((Object)this.fileContent);
            this.fileService.writeToFile(bytes);
            this.fileContent.setModified(false);
        }
    }

    public FileEncodingManager getFileEncodingManager() {
        return this.fileEncodingManager;
    }

    public FileContent getFileContent() {
        return this.fileContent;
    }
}

