/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.fs;

import com.gigaspaces.security.AccessDeniedException;
import com.gigaspaces.security.directory.UserAlreadyExistsException;
import com.gigaspaces.security.directory.UserDataAccessException;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.security.directory.UserManager;
import com.gigaspaces.security.directory.UserNotFoundException;
import com.gigaspaces.security.fs.FileServiceAccessor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;

public class FileUserManager
implements UserManager {
    private final FileServiceAccessor fileServiceAccessor;
    private final boolean isReadOnly;

    public FileUserManager(FileServiceAccessor fileServiceAccessor, boolean isReadOnly) {
        this.fileServiceAccessor = fileServiceAccessor;
        this.isReadOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void createUser(UserDetails userDetails) throws UserAlreadyExistsException, UserDataAccessException, AccessDeniedException {
        if (this.isReadOnly()) {
            throw new AccessDeniedException("Insufficient privileges for creating users; Read-only operations allowed");
        }
        if (this.userExists(userDetails.getUsername())) {
            throw new UserAlreadyExistsException("Could not create non-unique user: " + userDetails.getUsername());
        }
        this.encodeUserPassword(userDetails);
        this.fileServiceAccessor.getFileContent().getUserDetails().put(userDetails.getUsername(), userDetails);
        this.fileServiceAccessor.getFileContent().setModified(true);
    }

    public void deleteUser(String username) throws UserNotFoundException, UserDataAccessException, AccessDeniedException {
        if (this.isReadOnly()) {
            throw new AccessDeniedException("Insufficient privileges for deleting users; Read-only operations allowed");
        }
        UserDetails removed = this.fileServiceAccessor.getFileContent().getUserDetails().remove(username);
        if (removed == null) {
            throw new UserNotFoundException("Could not delete user: " + username);
        }
        this.fileServiceAccessor.getFileContent().setModified(true);
    }

    public UserDetails getUser(String username) throws UserNotFoundException, UserDataAccessException {
        UserDetails userDetails = this.fileServiceAccessor.getFileContent().getUserDetails().get(username);
        if (userDetails == null) {
            throw new UserNotFoundException("Could not find user: " + username);
        }
        return userDetails;
    }

    public Map<String, UserDetails> mapUsers() throws UserDataAccessException {
        return Collections.unmodifiableMap(this.fileServiceAccessor.getFileContent().getUserDetails());
    }

    public void updateUser(UserDetails userDetails) throws UserNotFoundException, UserDataAccessException {
        if (this.isReadOnly()) {
            throw new AccessDeniedException("Insufficient privileges for updating users; Read-only operations allowed");
        }
        UserDetails oldUserDetails = this.fileServiceAccessor.getFileContent().getUserDetails().get(userDetails.getUsername());
        if (oldUserDetails == null) {
            throw new UserNotFoundException("Could not update user: " + userDetails.getUsername());
        }
        if (!oldUserDetails.getPassword().equals(userDetails.getPassword())) {
            this.encodeUserPassword(userDetails);
        }
        this.fileServiceAccessor.getFileContent().getUserDetails().put(userDetails.getUsername(), userDetails);
        this.fileServiceAccessor.getFileContent().setModified(true);
    }

    public boolean userExists(String username) throws UserDataAccessException {
        return this.fileServiceAccessor.getFileContent().getUserDetails().containsKey(username);
    }

    private void encodeUserPassword(UserDetails userDetails) {
        String encodedPassword = this.fileServiceAccessor.getFileEncodingManager().getPasswordEncoder().encodePassword(userDetails.getPassword());
        if (encodedPassword.equals(userDetails.getPassword())) {
            return;
        }
        try {
            Method method = userDetails.getClass().getMethod("setPassword", String.class);
            method.invoke((Object)userDetails, encodedPassword);
        }
        catch (Exception e) {
            throw new UserDataAccessException("Failed setting encrypted password", (Throwable)e);
        }
    }
}

