/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.fs;

import com.gigaspaces.security.fs.FileService;
import com.gigaspaces.start.SystemInfo;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalFileService
implements FileService {
    private static final Logger logger = Logger.getLogger(LocalFileService.class.getPackage().getName());
    public static final String FILE_PATH_PROPERTY_KEY = "com.gs.security.fs.file-service.file-path";
    public static final String FILE_PATH_DEFAULT_VAL = "security/gs-directory.fsm";
    private File file;

    @Override
    public void init(Properties properties) throws IOException {
        String pathname = properties.getProperty(FILE_PATH_PROPERTY_KEY, FILE_PATH_DEFAULT_VAL).trim();
        this.file = new File(pathname);
        if (!this.file.exists()) {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(pathname);
            if (resource != null) {
                try {
                    this.file = new File(resource.toURI());
                }
                catch (URISyntaxException e) {
                    IOException ioe = new IOException("Failed to initialize file: [" + pathname + "]");
                    ioe.initCause(e);
                    throw ioe;
                }
            } else {
                this.file = properties.containsKey(FILE_PATH_PROPERTY_KEY) ? new File(pathname) : new File(SystemInfo.singleton().getXapHome() + File.separator + FILE_PATH_DEFAULT_VAL);
            }
        }
        if (!this.file.exists()) {
            logger.log(Level.WARNING, "Security file-path denotes a missing file: [" + this.file.getAbsolutePath() + "] - Contents will be loaded once the file is available.");
        }
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Security file-path: " + this.file.getAbsolutePath());
        }
    }

    @Override
    public boolean fileExists() {
        return this.file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readFromFile() throws IOException {
        if (!this.file.exists()) {
            return new byte[0];
        }
        FileInputStream fis = new FileInputStream(this.file);
        DataInputStream dis = new DataInputStream(fis);
        int length = (int)this.file.length();
        byte[] bytes = new byte[length];
        try {
            dis.readFully(bytes);
        }
        finally {
            dis.close();
        }
        return bytes;
    }

    @Override
    public void writeToFile(byte[] bytes) throws IOException {
        LocalFileService.createNewFileIfNeeded(this.file);
        try (FileOutputStream fos = new FileOutputStream(this.file);){
            fos.write(bytes);
            fos.flush();
        }
    }

    private static void createNewFileIfNeeded(File file) throws IOException {
        if (!file.exists()) {
            boolean created;
            File parent = file.getParentFile();
            if (parent != null && !parent.exists() && !(created = parent.mkdirs())) {
                throw new IOException("Failed to create parent directories: " + parent.getAbsolutePath());
            }
            created = file.createNewFile();
            if (!created) {
                throw new IOException("Failed to create file: " + file.getAbsolutePath());
            }
        }
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }
}

