/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.fs;

import com.gigaspaces.security.fs.FileService;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class URLFileService
implements FileService {
    private static final Logger logger = Logger.getLogger(URLFileService.class.getPackage().getName());
    public static final String URL_PROPERTY_KEY = "com.gs.security.fs.file-service.url";
    private URL url;

    @Override
    public void init(Properties properties) throws IOException {
        String spec = properties.getProperty(URL_PROPERTY_KEY).trim();
        if (spec == null) {
            throw new IllegalArgumentException("Illegal 'null' value given for property: com.gs.security.fs.file-service.url");
        }
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Security file URL: " + spec);
        }
        this.url = new URL(spec);
        if (logger.isLoggable(Level.WARNING) && !this.fileExists()) {
            logger.log(Level.WARNING, "Failed to read from URL: [" + this.url.getPath() + "]");
        }
    }

    @Override
    public boolean fileExists() {
        try {
            InputStream openStream = this.url.openStream();
            openStream.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readFromFile() throws IOException {
        ByteArrayOutputStream tmpOut = new ByteArrayOutputStream();
        URLConnection urlConnection = this.url.openConnection();
        urlConnection.setDoInput(true);
        urlConnection.setUseCaches(false);
        try (InputStream in = urlConnection.getInputStream();){
            byte[] bytes;
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) != -1) {
                tmpOut.write(buf, 0, len);
            }
            tmpOut.close();
            byte[] byArray = bytes = tmpOut.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToFile(byte[] bytes) throws IOException {
        URLConnection urlConnection = this.url.openConnection();
        urlConnection.setDoOutput(true);
        try (OutputStream os = urlConnection.getOutputStream();){
            os.write(bytes);
            os.flush();
        }
        if (!this.fileExists()) {
            throw new FileNotFoundException("Failed to find written file on URL: [" + this.url.getPath() + "]");
        }
    }

    @Override
    public long lastModified() {
        try {
            URLConnection openConnection = this.url.openConnection();
            return openConnection.getLastModified();
        }
        catch (IOException e) {
            return -1L;
        }
    }
}

