/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.spring;

import com.gigaspaces.security.AccessDeniedException;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.AuthenticationException;
import com.gigaspaces.security.Authority;
import com.gigaspaces.security.AuthorityFactory;
import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.SecurityManager;
import com.gigaspaces.security.directory.DirectoryAccessDeniedException;
import com.gigaspaces.security.directory.DirectoryManager;
import com.gigaspaces.security.directory.User;
import com.gigaspaces.security.directory.UserDetails;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class SpringSecurityManager
implements SecurityManager {
    public static final String SPRING_SECURITY_CONFIG_LOCATION = "spring-security-config-location";
    private static final Logger logger = Logger.getLogger(SecurityManager.class.getPackage().getName());
    private ApplicationContext applicationContext;
    private AuthenticationManager authenticationManager;

    public void init(Properties properties) throws SecurityException {
        String configLocation = properties.getProperty(SPRING_SECURITY_CONFIG_LOCATION, "security-config.xml");
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("spring-security-config-location: " + configLocation + ", absolute path: " + new File(configLocation).getAbsolutePath());
        }
        this.applicationContext = new FileSystemXmlApplicationContext(configLocation);
        Map beansOfType = this.applicationContext.getBeansOfType(AuthenticationManager.class);
        if (beansOfType.isEmpty()) {
            throw new SecurityException("No bean of type '" + AuthenticationManager.class.getName() + "' is defined in " + configLocation);
        }
        if (beansOfType.size() > 1) {
            throw new SecurityException("More than one bean of type '" + AuthenticationManager.class.getName() + "' is defined in " + configLocation);
        }
        this.authenticationManager = (AuthenticationManager)beansOfType.values().iterator().next();
    }

    public Authentication authenticate(UserDetails userDetails) throws AuthenticationException {
        try {
            org.springframework.security.core.Authentication authenticate = this.authenticationManager.authenticate(this.createAuthenticationRequest(userDetails));
            if (!authenticate.isAuthenticated()) {
                throw new AuthenticationException("Authentication failed for user [" + userDetails.getUsername() + "]");
            }
            Collection grantedAuthorities = authenticate.getAuthorities();
            ArrayList<Authority> authoritiesList = new ArrayList<Authority>(grantedAuthorities.size());
            for (GrantedAuthority grantedAuthority : grantedAuthorities) {
                Authority gsAuthority = AuthorityFactory.create((String)grantedAuthority.getAuthority().trim());
                authoritiesList.add(gsAuthority);
            }
            User user = new User(userDetails.getUsername(), userDetails.getPassword(), authoritiesList.toArray(new Authority[authoritiesList.size()]));
            Authentication authentication = new Authentication((UserDetails)user);
            return authentication;
        }
        catch (Exception exception) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Caught exception upon authentication: " + exception, exception);
            }
            throw new AuthenticationException((Throwable)exception);
        }
    }

    protected org.springframework.security.core.Authentication createAuthenticationRequest(UserDetails userDetails) {
        return new UsernamePasswordAuthenticationToken((Object)userDetails.getUsername(), (Object)userDetails.getPassword());
    }

    public void close() {
        if (this.applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.applicationContext).close();
        }
    }

    public DirectoryManager createDirectoryManager(UserDetails userDetails) throws AuthenticationException, AccessDeniedException {
        throw new DirectoryAccessDeniedException("user/role information should be managed by a compatible external directory tools.");
    }
}

