/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.twitter;

import org.apache.spark.internal.Logging;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.receiver.Receiver;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import twitter4j.FilterQuery;
import twitter4j.StallWarning;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.StatusListener;
import twitter4j.TwitterStream;
import twitter4j.TwitterStreamFactory;
import twitter4j.auth.Authorization;

@ScalaSignature(bytes="\u0006\u0001=4Q!\u0001\u0002\u0001\t1\u0011q\u0002V<jiR,'OU3dK&4XM\u001d\u0006\u0003\u0007\u0011\tq\u0001^<jiR,'O\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\r\u0011\u00079\t2#D\u0001\u0010\u0015\t\u0001B!\u0001\u0005sK\u000e,\u0017N^3s\u0013\t\u0011rB\u0001\u0005SK\u000e,\u0017N^3s!\t!r#D\u0001\u0016\u0015\u00051\u0012!\u0003;xSR$XM\u001d\u001bk\u0013\tARC\u0001\u0004Ti\u0006$Xo\u001d\t\u00035ui\u0011a\u0007\u0006\u00039\u0019\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003=m\u0011q\u0001T8hO&tw\r\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003#\u0003-!x/\u001b;uKJ\fU\u000f\u001e5\u0004\u0001A\u00111EJ\u0007\u0002I)\u0011Q%F\u0001\u0005CV$\b.\u0003\u0002(I\ti\u0011)\u001e;i_JL'0\u0019;j_:D\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0006cV,'/\u001f\t\u0004W9\u0002T\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\r=\u0003H/[8o!\t!\u0012'\u0003\u00023+\tYa)\u001b7uKJ\fV/\u001a:z\u0011%!\u0004A!A!\u0002\u0013)4(\u0001\u0007ti>\u0014\u0018mZ3MKZ,G\u000e\u0005\u00027s5\tqG\u0003\u00029\r\u000591\u000f^8sC\u001e,\u0017B\u0001\u001e8\u00051\u0019Fo\u001c:bO\u0016dUM^3m\u0013\t!\u0014\u0003C\u0003>\u0001\u0011\u0005a(\u0001\u0004=S:LGO\u0010\u000b\u0005\u007f\u0005\u00135\t\u0005\u0002A\u00015\t!\u0001C\u0003!y\u0001\u0007!\u0005C\u0003*y\u0001\u0007!\u0006C\u00035y\u0001\u0007Q\u0007C\u0005F\u0001\u0001\u0007\t\u0019!C\u0005\r\u0006iAo^5ui\u0016\u00148\u000b\u001e:fC6,\u0012a\u0012\t\u0003)!K!!S\u000b\u0003\u001bQ;\u0018\u000e\u001e;feN#(/Z1n\u0011%Y\u0005\u00011AA\u0002\u0013%A*A\tuo&$H/\u001a:TiJ,\u0017-\\0%KF$\"!\u0014)\u0011\u0005-r\u0015BA(-\u0005\u0011)f.\u001b;\t\u000fES\u0015\u0011!a\u0001\u000f\u0006\u0019\u0001\u0010J\u0019\t\rM\u0003\u0001\u0015)\u0003H\u00039!x/\u001b;uKJ\u001cFO]3b[\u0002B#AU+\u0011\u0005-2\u0016BA,-\u0005!1x\u000e\\1uS2,\u0007bB-\u0001\u0001\u0004%IAW\u0001\bgR|\u0007\u000f]3e+\u0005Y\u0006CA\u0016]\u0013\tiFFA\u0004C_>dW-\u00198\t\u000f}\u0003\u0001\u0019!C\u0005A\u0006Y1\u000f^8qa\u0016$w\fJ3r)\ti\u0015\rC\u0004R=\u0006\u0005\t\u0019A.\t\r\r\u0004\u0001\u0015)\u0003\\\u0003!\u0019Ho\u001c9qK\u0012\u0004\u0003F\u00012V\u0011\u00151\u0007\u0001\"\u0001h\u0003\u001dygn\u0015;beR$\u0012!\u0014\u0005\u0006S\u0002!\taZ\u0001\u0007_:\u001cFo\u001c9\t\u000b-\u0004A\u0011\u00027\u0002!M,G\u000fV<jiR,'o\u0015;sK\u0006lGCA'n\u0011\u0015q'\u000e1\u0001H\u0003AqWm\u001e+xSR$XM]*ue\u0016\fW\u000e")
public class TwitterReceiver
extends Receiver<Status>
implements Logging {
    private final Authorization twitterAuth;
    private final Option<FilterQuery> query;
    private volatile TwitterStream twitterStream;
    private volatile boolean org$apache$spark$streaming$twitter$TwitterReceiver$$stopped;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private TwitterStream twitterStream() {
        return this.twitterStream;
    }

    private void twitterStream_$eq(TwitterStream x$1) {
        this.twitterStream = x$1;
    }

    public boolean org$apache$spark$streaming$twitter$TwitterReceiver$$stopped() {
        return this.org$apache$spark$streaming$twitter$TwitterReceiver$$stopped;
    }

    private void org$apache$spark$streaming$twitter$TwitterReceiver$$stopped_$eq(boolean x$1) {
        this.org$apache$spark$streaming$twitter$TwitterReceiver$$stopped = x$1;
    }

    public void onStart() {
        try {
            TwitterStream newTwitterStream = new TwitterStreamFactory().getInstance(this.twitterAuth);
            newTwitterStream.addListener(new StatusListener(this){
                private final /* synthetic */ TwitterReceiver $outer;

                public void onStatus(Status status) {
                    this.$outer.store(status);
                }

                public void onDeletionNotice(StatusDeletionNotice statusDeletionNotice) {
                }

                public void onTrackLimitationNotice(int i) {
                }

                public void onScrubGeo(long l, long l1) {
                }

                public void onStallWarning(StallWarning stallWarning) {
                }

                public void onException(Exception e) {
                    if (!this.$outer.org$apache$spark$streaming$twitter$TwitterReceiver$$stopped()) {
                        this.$outer.restart("Error receiving tweets", e);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            if (this.query.isDefined()) {
                newTwitterStream.filter(this.query.get());
            } else {
                newTwitterStream.sample();
            }
            this.setTwitterStream(newTwitterStream);
            this.logInfo((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Twitter receiver started";
                }
            }));
            this.org$apache$spark$streaming$twitter$TwitterReceiver$$stopped_$eq(false);
        }
        catch (Exception exception) {
            this.restart("Error starting Twitter stream", exception);
        }
    }

    public void onStop() {
        this.org$apache$spark$streaming$twitter$TwitterReceiver$$stopped_$eq(true);
        this.setTwitterStream(null);
        this.logInfo((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Twitter receiver stopped";
            }
        }));
    }

    private synchronized void setTwitterStream(TwitterStream newTwitterStream) {
        if (this.twitterStream() != null) {
            this.twitterStream().shutdown();
        }
        this.twitterStream_$eq(newTwitterStream);
    }

    public TwitterReceiver(Authorization twitterAuth, Option<FilterQuery> query, StorageLevel storageLevel) {
        this.twitterAuth = twitterAuth;
        this.query = query;
        super(storageLevel);
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$streaming$twitter$TwitterReceiver$$stopped = false;
    }
}

