/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.twitter;

import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream;
import org.apache.spark.streaming.api.java.JavaReceiverInputDStream$;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.twitter.TwitterInputDStream;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import twitter4j.FilterQuery;
import twitter4j.Status;
import twitter4j.auth.Authorization;

public final class TwitterUtils$ {
    public static final TwitterUtils$ MODULE$;

    static {
        new TwitterUtils$();
    }

    public ReceiverInputDStream<Status> createFilteredStream(StreamingContext ssc, Option<Authorization> twitterAuth, Option<FilterQuery> query, StorageLevel storageLevel) {
        return new TwitterInputDStream(ssc, twitterAuth, query, storageLevel);
    }

    public ReceiverInputDStream<Status> createStream(StreamingContext ssc, Option<Authorization> twitterAuth, Seq<String> filters, StorageLevel storageLevel) {
        Option query = filters.nonEmpty() ? new Some<FilterQuery>(new FilterQuery().track(filters.mkString(","))) : None$.MODULE$;
        return this.createFilteredStream(ssc, twitterAuth, query, storageLevel);
    }

    public JavaReceiverInputDStream<Status> createStream(JavaStreamingContext jssc) {
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), None$.MODULE$, this.createStream$default$3(), this.createStream$default$4()), ClassTag$.MODULE$.apply(Status.class));
    }

    public JavaReceiverInputDStream<Status> createStream(JavaStreamingContext jssc, String[] filters) {
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), None$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])filters), this.createStream$default$4()), ClassTag$.MODULE$.apply(Status.class));
    }

    public JavaReceiverInputDStream<Status> createStream(JavaStreamingContext jssc, String[] filters, StorageLevel storageLevel) {
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), None$.MODULE$, Predef$.MODULE$.wrapRefArray((Object[])filters), storageLevel), ClassTag$.MODULE$.apply(Status.class));
    }

    public JavaReceiverInputDStream<Status> createStream(JavaStreamingContext jssc, Authorization twitterAuth) {
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), new Some<Authorization>(twitterAuth), this.createStream$default$3(), this.createStream$default$4()), ClassTag$.MODULE$.apply(Status.class));
    }

    public JavaReceiverInputDStream<Status> createStream(JavaStreamingContext jssc, Authorization twitterAuth, String[] filters) {
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), new Some<Authorization>(twitterAuth), Predef$.MODULE$.wrapRefArray((Object[])filters), this.createStream$default$4()), ClassTag$.MODULE$.apply(Status.class));
    }

    public JavaReceiverInputDStream<Status> createStream(JavaStreamingContext jssc, Authorization twitterAuth, String[] filters, StorageLevel storageLevel) {
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createStream(jssc.ssc(), new Some<Authorization>(twitterAuth), Predef$.MODULE$.wrapRefArray((Object[])filters), storageLevel), ClassTag$.MODULE$.apply(Status.class));
    }

    public Seq<String> createStream$default$3() {
        return Nil$.MODULE$;
    }

    public StorageLevel createStream$default$4() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK_SER_2();
    }

    public JavaReceiverInputDStream<Status> createFilteredStream(JavaStreamingContext jssc, Authorization twitterAuth, FilterQuery query, StorageLevel storageLevel) {
        return JavaReceiverInputDStream$.MODULE$.fromReceiverInputDStream(this.createFilteredStream(jssc.ssc(), new Some<Authorization>(twitterAuth), new Some<FilterQuery>(query), storageLevel), ClassTag$.MODULE$.apply(Status.class));
    }

    public Option<FilterQuery> createFilteredStream$default$3() {
        return None$.MODULE$;
    }

    public StorageLevel createFilteredStream$default$4() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK_SER_2();
    }

    private TwitterUtils$() {
        MODULE$ = this;
    }
}

