/*
 * Decompiled with CFR 0.152.
 */
package org.insightedge.examples.geospatial;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.insightedge.examples.geospatial.GasStation;
import org.insightedge.spark.context.InsightEdgeConfig;
import org.insightedge.spark.context.InsightEdgeConfig$;
import org.insightedge.spark.implicits;
import org.insightedge.spark.rdd.InsightEdgeRDDFunctions;
import org.openspaces.spatial.ShapeFactory;
import org.openspaces.spatial.shapes.Circle;
import org.openspaces.spatial.shapes.Point;
import org.openspaces.spatial.shapes.Shape;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

public final class LoadDataFrameWithGeospatial$ {
    public static final LoadDataFrameWithGeospatial$ MODULE$;

    static {
        new LoadDataFrameWithGeospatial$();
    }

    public void main(String[] args) {
        String[] stringArray;
        Option option;
        String[] settings;
        InsightEdgeConfig initConfig = InsightEdgeConfig$.MODULE$.fromSparkConf(new SparkConf());
        String[] stringArray2 = settings = args.length > 0 ? args : (String[])((Object[])new String[]{new SparkConf().get("spark.master", InsightEdgeConfig$.MODULE$.SPARK_MASTER_LOCAL_URL_DEFAULT()), initConfig.spaceName()});
        if (settings.length != 2) {
            System.err.println("Usage: LoadDataFrameWithGeospatial <spark master url> <space name>");
            System.exit(1);
        }
        if (!(option = Array$.MODULE$.unapplySeq(stringArray = settings)).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2<String, String> tuple2;
            String master = (String)((SeqLike)option.get()).apply(0);
            String space = (String)((SeqLike)option.get()).apply(1);
            Tuple2<String, String> tuple22 = tuple2 = new Tuple2<String, String>(master, space);
            String master2 = tuple22._1();
            String space2 = tuple22._2();
            InsightEdgeConfig ieConfig = initConfig.copy(space2, initConfig.copy$default$2(), initConfig.copy$default$3());
            SparkSession spark = implicits.all$.MODULE$.SparkSessionBuilderExtension(SparkSession$.MODULE$.builder().appName("example-load-dataframe-geospatial").master(master2)).insightEdgeConfig(ieConfig).getOrCreate();
            SparkContext sc = spark.sparkContext();
            IndexedSeq stations = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100000).map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final GasStation apply(int i) {
                    return new GasStation(i, new StringBuilder().append((Object)"Station").append(BoxesRunTime.boxToInteger(i)).toString(), LoadDataFrameWithGeospatial$.MODULE$.randomPoint(-50.0, 50.0));
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Saving ", " gas stations RDD to the space"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(stations.size())})));
            InsightEdgeRDDFunctions qual$1 = implicits.all$.MODULE$.saveToDataGridExtension(sc.parallelize(stations, sc.parallelize$default$2(), ClassTag$.MODULE$.apply(GasStation.class)), ClassTag$.MODULE$.apply(GasStation.class));
            int x$2 = qual$1.saveToGrid$default$1();
            qual$1.saveToGrid(x$2);
            Point userLocation = ShapeFactory.point((double)10.0, (double)10.0);
            Circle searchArea = ShapeFactory.circle((Point)userLocation, (double)10.0);
            Dataset df = implicits.all$.MODULE$.DataFrameReaderWrapper(spark.read()).grid(ClassTag$.MODULE$.apply(GasStation.class));
            long countNearby = df.filter(implicits.all$.MODULE$.ColumnWrapper(df.apply("location")).geoWithin((Shape)searchArea)).count();
            Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of stations within 10 radius around user: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(countNearby)})));
            implicits.all$.MODULE$.SparkSessionExtension(spark).stopInsightEdgeContext();
            return;
        }
        throw new MatchError(stringArray);
    }

    public Point randomPoint(double min2, double max2) {
        return ShapeFactory.point((double)this.randomInRange(min2, max2), (double)this.randomInRange(min2, max2));
    }

    public double randomInRange(double min2, double max2) {
        return Random$.MODULE$.nextDouble() * (max2 - min2) + min2;
    }

    private LoadDataFrameWithGeospatial$() {
        MODULE$ = this;
    }
}

