/*
 * Decompiled with CFR 0.152.
 */
package org.insightedge.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.insightedge.spark.context.InsightEdgeConfig;
import org.insightedge.spark.context.InsightEdgeConfig$;
import org.insightedge.spark.implicits;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;

public final class SaveAndLoadMLModel$ {
    public static final SaveAndLoadMLModel$ MODULE$;

    static {
        new SaveAndLoadMLModel$();
    }

    public void main(String[] args) {
        String[] stringArray;
        Option option;
        String[] settings;
        InsightEdgeConfig initConfig = InsightEdgeConfig$.MODULE$.fromSparkConf(new SparkConf());
        String[] stringArray2 = settings = args.length > 0 ? args : (String[])((Object[])new String[]{new SparkConf().get("spark.master", InsightEdgeConfig$.MODULE$.SPARK_MASTER_LOCAL_URL_DEFAULT()), initConfig.spaceName()});
        if (settings.length != 2) {
            System.err.println("Usage: SaveAndLoadMLModel <spark master url> <space name>");
            System.exit(1);
        }
        if (!(option = Array$.MODULE$.unapplySeq(stringArray = settings)).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            Tuple2<String, String> tuple2;
            String master = (String)((SeqLike)option.get()).apply(0);
            String space = (String)((SeqLike)option.get()).apply(1);
            Tuple2<String, String> tuple22 = tuple2 = new Tuple2<String, String>(master, space);
            String master2 = tuple22._1();
            String space2 = tuple22._2();
            InsightEdgeConfig ieConfig = initConfig.copy(space2, initConfig.copy$default$2(), initConfig.copy$default$3());
            SparkSession spark = implicits.all$.MODULE$.SparkSessionBuilderExtension(SparkSession$.MODULE$.builder().appName("example-mllib").master(master2)).insightEdgeConfig(ieConfig).getOrCreate();
            SparkContext sc = spark.sparkContext();
            String modelName = "decisionTreeModel";
            KMeansModel model = this.createModel(sc);
            Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Saving ", " to the datagrid"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{model.getClass().getSimpleName()})));
            implicits.all$.MODULE$.SaveToGridExtension((Saveable)model).saveToGrid(implicits.all$.MODULE$.insightEdgeSparkContext(sc), modelName);
            Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading ", " from the datagrid"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{modelName})));
            KMeansModel loadedModel = (KMeansModel)implicits.all$.MODULE$.insightEdgeSparkContext(sc).loadMLInstance(modelName, ClassTag$.MODULE$.apply(KMeansModel.class)).get();
            Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Model ", " is loaded"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{loadedModel.getClass().getSimpleName()})));
            implicits.all$.MODULE$.SparkSessionExtension(spark).stopInsightEdgeContext();
            return;
        }
        throw new MatchError(stringArray);
    }

    private KMeansModel createModel(SparkContext sc) {
        GenTraversable vectors = List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 3.0})), Vectors$.MODULE$.dense(2.0, Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0})), Vectors$.MODULE$.dense(2.0, Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0}))}));
        RDD rdd = sc.parallelize((Seq)vectors, sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Vector.class));
        int k = 2;
        int maxIterations = 100;
        return KMeans$.MODULE$.train(rdd, k, maxIterations);
    }

    private SaveAndLoadMLModel$() {
        MODULE$ = this;
    }
}

