/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

public final class BASE64Encoder {
    private static final char last2byte = (char)Integer.parseInt("00000011", 2);
    private static final char last4byte = (char)Integer.parseInt("00001111", 2);
    private static final char last6byte = (char)Integer.parseInt("00111111", 2);
    private static final char lead6byte = (char)Integer.parseInt("11111100", 2);
    private static final char lead4byte = (char)Integer.parseInt("11110000", 2);
    private static final char lead2byte = (char)Integer.parseInt("11000000", 2);
    private static final char[] encodeTable = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    private BASE64Encoder() {
    }

    public static String encode(byte[] from2) {
        int i;
        StringBuilder to2 = new StringBuilder((int)((double)from2.length * 1.34) + 3);
        int num = 0;
        int currentByte = 0;
        for (i = 0; i < from2.length; ++i) {
            num %= 8;
            while (num < 8) {
                switch (num) {
                    case 0: {
                        currentByte = (char)(from2[i] & lead6byte);
                        currentByte = (char)(currentByte >>> 2);
                        break;
                    }
                    case 2: {
                        currentByte = (char)(from2[i] & last6byte);
                        break;
                    }
                    case 4: {
                        currentByte = (char)(from2[i] & last4byte);
                        currentByte = (char)(currentByte << 2);
                        if (i + 1 >= from2.length) break;
                        currentByte = (char)(currentByte | (from2[i + 1] & lead2byte) >>> 6);
                        break;
                    }
                    case 6: {
                        currentByte = (char)(from2[i] & last2byte);
                        currentByte = (char)(currentByte << 4);
                        if (i + 1 >= from2.length) break;
                        currentByte = (char)(currentByte | (from2[i + 1] & lead4byte) >>> 4);
                    }
                }
                to2.append(encodeTable[currentByte]);
                num += 6;
            }
        }
        if (to2.length() % 4 != 0) {
            for (i = 4 - to2.length() % 4; i > 0; --i) {
                to2.append("=");
            }
        }
        return to2.toString();
    }
}

