/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import twitter4j.HttpClient;
import twitter4j.HttpClientBase;
import twitter4j.HttpClientConfiguration;
import twitter4j.HttpParameter;
import twitter4j.HttpRequest;
import twitter4j.HttpResponse;
import twitter4j.HttpResponseCode;
import twitter4j.HttpResponseImpl;
import twitter4j.Logger;
import twitter4j.RequestMethod;
import twitter4j.TwitterException;
import twitter4j.conf.ConfigurationContext;

class HttpClientImpl
extends HttpClientBase
implements HttpResponseCode,
Serializable {
    private static final Logger logger = Logger.getLogger(HttpClientImpl.class);
    private static final long serialVersionUID = -403500272719330534L;
    private static final Map<HttpClientConfiguration, HttpClient> instanceMap;

    public HttpClientImpl() {
        super(ConfigurationContext.getInstance().getHttpClientConfiguration());
    }

    public HttpClientImpl(HttpClientConfiguration conf) {
        super(conf);
    }

    public static HttpClient getInstance(HttpClientConfiguration conf) {
        HttpClient client = instanceMap.get(conf);
        if (null == client) {
            client = new HttpClientImpl(conf);
            instanceMap.put(conf, client);
        }
        return client;
    }

    @Override
    public HttpResponse get(String url) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.GET, url, null, null, null));
    }

    public HttpResponse post(String url, HttpParameter[] params) throws TwitterException {
        return this.request(new HttpRequest(RequestMethod.POST, url, params, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse handleRequest(HttpRequest req) throws TwitterException {
        int retry = this.CONF.getHttpRetryCount() + 1;
        HttpResponse res = null;
        for (int retriedCount = 0; retriedCount < retry; ++retriedCount) {
            block26: {
                int responseCode = -1;
                try {
                    OutputStream os = null;
                    try {
                        HttpURLConnection con = this.getConnection(req.getURL());
                        con.setDoInput(true);
                        this.setHeaders(req, con);
                        con.setRequestMethod(req.getMethod().name());
                        if (req.getMethod() == RequestMethod.POST) {
                            if (HttpParameter.containsFile(req.getParameters())) {
                                String boundary = "----Twitter4J-upload" + System.currentTimeMillis();
                                con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                                boundary = "--" + boundary;
                                con.setDoOutput(true);
                                os = con.getOutputStream();
                                DataOutputStream out = new DataOutputStream(os);
                                for (HttpParameter param2 : req.getParameters()) {
                                    if (param2.isFile()) {
                                        int length;
                                        this.write(out, boundary + "\r\n");
                                        this.write(out, "Content-Disposition: form-data; name=\"" + param2.getName() + "\"; filename=\"" + param2.getFile().getName() + "\"\r\n");
                                        this.write(out, "Content-Type: " + param2.getContentType() + "\r\n\r\n");
                                        BufferedInputStream in = new BufferedInputStream(param2.hasFileBody() ? param2.getFileBody() : new FileInputStream(param2.getFile()));
                                        byte[] buff = new byte[1024];
                                        while ((length = in.read(buff)) != -1) {
                                            out.write(buff, 0, length);
                                        }
                                        this.write(out, "\r\n");
                                        in.close();
                                        continue;
                                    }
                                    this.write(out, boundary + "\r\n");
                                    this.write(out, "Content-Disposition: form-data; name=\"" + param2.getName() + "\"\r\n");
                                    this.write(out, "Content-Type: text/plain; charset=UTF-8\r\n\r\n");
                                    logger.debug(param2.getValue());
                                    out.write(param2.getValue().getBytes("UTF-8"));
                                    this.write(out, "\r\n");
                                }
                                this.write(out, boundary + "--\r\n");
                                this.write(out, "\r\n");
                            } else {
                                con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                                String postParam = HttpParameter.encodeParameters(req.getParameters());
                                logger.debug("Post Params: ", postParam);
                                byte[] bytes = postParam.getBytes("UTF-8");
                                con.setRequestProperty("Content-Length", Integer.toString(bytes.length));
                                con.setDoOutput(true);
                                os = con.getOutputStream();
                                os.write(bytes);
                            }
                            os.flush();
                            os.close();
                        }
                        res = new HttpResponseImpl(con, this.CONF);
                        responseCode = con.getResponseCode();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Response: ");
                            Map<String, List<String>> responseHeaders = con.getHeaderFields();
                            for (String key : responseHeaders.keySet()) {
                                List<String> values = responseHeaders.get(key);
                                for (String value : values) {
                                    if (key != null) {
                                        logger.debug(key + ": " + value);
                                        continue;
                                    }
                                    logger.debug(value);
                                }
                            }
                        }
                        if (responseCode >= 200 && (responseCode == 302 || 300 > responseCode)) break;
                        if (responseCode == 420 || responseCode == 400 || responseCode < 500 || retriedCount == this.CONF.getHttpRetryCount()) {
                            throw new TwitterException(res.asString(), res);
                        }
                    }
                    finally {
                        try {
                            os.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (IOException ioe) {
                    if (retriedCount != this.CONF.getHttpRetryCount()) break block26;
                    throw new TwitterException(ioe.getMessage(), ioe, responseCode);
                }
            }
            try {
                if (logger.isDebugEnabled() && res != null) {
                    res.asString();
                }
                logger.debug("Sleeping " + this.CONF.getHttpRetryIntervalSeconds() + " seconds until the next retry.");
                Thread.sleep(this.CONF.getHttpRetryIntervalSeconds() * 1000);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return res;
    }

    private void setHeaders(HttpRequest req, HttpURLConnection connection) {
        String authorizationHeader;
        if (logger.isDebugEnabled()) {
            logger.debug("Request: ");
            logger.debug(req.getMethod().name() + " ", req.getURL());
        }
        if (req.getAuthorization() != null && (authorizationHeader = req.getAuthorization().getAuthorizationHeader(req)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Authorization: ", authorizationHeader.replaceAll(".", "*"));
            }
            connection.addRequestProperty("Authorization", authorizationHeader);
        }
        if (req.getRequestHeaders() != null) {
            for (String key : req.getRequestHeaders().keySet()) {
                connection.addRequestProperty(key, req.getRequestHeaders().get(key));
                logger.debug(key + ": " + req.getRequestHeaders().get(key));
            }
        }
    }

    HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection con;
        if (this.isProxyConfigured()) {
            if (this.CONF.getHttpProxyUser() != null && !this.CONF.getHttpProxyUser().equals("")) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Proxy AuthUser: " + this.CONF.getHttpProxyUser());
                    logger.debug("Proxy AuthPassword: " + this.CONF.getHttpProxyPassword().replaceAll(".", "*"));
                }
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
                            return new PasswordAuthentication(HttpClientImpl.this.CONF.getHttpProxyUser(), HttpClientImpl.this.CONF.getHttpProxyPassword().toCharArray());
                        }
                        return null;
                    }
                });
            }
            Proxy proxy = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(this.CONF.getHttpProxyHost(), this.CONF.getHttpProxyPort()));
            if (logger.isDebugEnabled()) {
                logger.debug("Opening proxied connection(" + this.CONF.getHttpProxyHost() + ":" + this.CONF.getHttpProxyPort() + ")");
            }
            con = (HttpURLConnection)new URL(url).openConnection(proxy);
        } else {
            con = (HttpURLConnection)new URL(url).openConnection();
        }
        if (this.CONF.getHttpConnectionTimeout() > 0) {
            con.setConnectTimeout(this.CONF.getHttpConnectionTimeout());
        }
        if (this.CONF.getHttpReadTimeout() > 0) {
            con.setReadTimeout(this.CONF.getHttpReadTimeout());
        }
        con.setInstanceFollowRedirects(false);
        return con;
    }

    static {
        try {
            if (Integer.parseInt((String)Class.forName("android.os.Build$VERSION").getField("SDK").get(null)) < 8) {
                System.setProperty("http.keepAlive", "false");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        instanceMap = new HashMap<HttpClientConfiguration, HttpClient>(1);
    }
}

