/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import twitter4j.GeoLocation;
import twitter4j.HttpParameter;

public final class Query
implements Serializable {
    private static final long serialVersionUID = 7196404519192910019L;
    private String query = null;
    private String lang = null;
    private String locale = null;
    private long maxId = -1L;
    private int count = -1;
    private String since = null;
    private long sinceId = -1L;
    private String geocode = null;
    private String until = null;
    private ResultType resultType = null;
    private String nextPageQuery = null;
    public static final Unit MILES = Unit.mi;
    public static final Unit KILOMETERS = Unit.km;
    public static final ResultType MIXED = ResultType.mixed;
    public static final ResultType POPULAR = ResultType.popular;
    public static final ResultType RECENT = ResultType.recent;
    private static final HttpParameter WITH_TWITTER_USER_ID = new HttpParameter("with_twitter_user_id", "true");

    public Query() {
    }

    public Query(String query) {
        this.query = query;
    }

    static Query createWithNextPageQuery(String nextPageQuery) {
        Query query = new Query();
        query.nextPageQuery = nextPageQuery;
        if (nextPageQuery != null) {
            String nextPageParameters = nextPageQuery.substring(1, nextPageQuery.length());
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            for (HttpParameter param2 : HttpParameter.decodeParameters(nextPageParameters)) {
                params.put(param2.getName(), param2.getValue());
            }
            if (params.containsKey("q")) {
                query.setQuery((String)params.get("q"));
            }
            if (params.containsKey("lang")) {
                query.setLang((String)params.get("lang"));
            }
            if (params.containsKey("locale")) {
                query.setLocale((String)params.get("locale"));
            }
            if (params.containsKey("max_id")) {
                query.setMaxId(Long.parseLong((String)params.get("max_id")));
            }
            if (params.containsKey("count")) {
                query.setCount(Integer.parseInt((String)params.get("count")));
            }
            if (params.containsKey("geocode")) {
                String[] parts = ((String)params.get("geocode")).split(",");
                double latitude = Double.parseDouble(parts[0]);
                double longitude = Double.parseDouble(parts[1]);
                double radius = 0.0;
                Unit unit = null;
                String radiusstr = parts[2];
                for (Unit value : Unit.values()) {
                    if (!radiusstr.endsWith(value.name())) continue;
                    radius = Double.parseDouble(radiusstr.substring(0, radiusstr.length() - 2));
                    unit = value;
                    break;
                }
                if (unit == null) {
                    throw new IllegalArgumentException("unrecognized geocode radius: " + radiusstr);
                }
                query.setGeoCode(new GeoLocation(latitude, longitude), radius, unit);
            }
            if (params.containsKey("result_type")) {
                query.setResultType(ResultType.valueOf((String)params.get("result_type")));
            }
        }
        return query;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Query query(String query) {
        this.setQuery(query);
        return this;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Query lang(String lang) {
        this.setLang(lang);
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public Query locale(String locale) {
        this.setLocale(locale);
        return this;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public void setMaxId(long maxId) {
        this.maxId = maxId;
    }

    public Query maxId(long maxId) {
        this.setMaxId(maxId);
        return this;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count2) {
        this.count = count2;
    }

    public Query count(int count2) {
        this.setCount(count2);
        return this;
    }

    public String getSince() {
        return this.since;
    }

    public void setSince(String since) {
        this.since = since;
    }

    public Query since(String since) {
        this.setSince(since);
        return this;
    }

    public long getSinceId() {
        return this.sinceId;
    }

    public void setSinceId(long sinceId) {
        this.sinceId = sinceId;
    }

    public Query sinceId(long sinceId) {
        this.setSinceId(sinceId);
        return this;
    }

    public String getGeocode() {
        return this.geocode;
    }

    public void setGeoCode(GeoLocation location, double radius, Unit unit) {
        this.geocode = location.getLatitude() + "," + location.getLongitude() + "," + radius + unit.name();
    }

    public void setGeoCode(GeoLocation location, double radius, String unit) {
        this.geocode = location.getLatitude() + "," + location.getLongitude() + "," + radius + unit;
    }

    public Query geoCode(GeoLocation location, double radius, String unit) {
        this.setGeoCode(location, radius, unit);
        return this;
    }

    public String getUntil() {
        return this.until;
    }

    public void setUntil(String until2) {
        this.until = until2;
    }

    public Query until(String until2) {
        this.setUntil(until2);
        return this;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public void setResultType(ResultType resultType) {
        this.resultType = resultType;
    }

    public Query resultType(ResultType resultType) {
        this.setResultType(resultType);
        return this;
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>(12);
        this.appendParameter("q", this.query, params);
        this.appendParameter("lang", this.lang, params);
        this.appendParameter("locale", this.locale, params);
        this.appendParameter("max_id", this.maxId, params);
        this.appendParameter("count", this.count, params);
        this.appendParameter("since", this.since, params);
        this.appendParameter("since_id", this.sinceId, params);
        this.appendParameter("geocode", this.geocode, params);
        this.appendParameter("until", this.until, params);
        if (this.resultType != null) {
            params.add(new HttpParameter("result_type", this.resultType.name()));
        }
        params.add(WITH_TWITTER_USER_ID);
        HttpParameter[] paramArray = new HttpParameter[params.size()];
        return params.toArray(paramArray);
    }

    private void appendParameter(String name, String value, List<HttpParameter> params) {
        if (value != null) {
            params.add(new HttpParameter(name, value));
        }
    }

    private void appendParameter(String name, long value, List<HttpParameter> params) {
        if (0L <= value) {
            params.add(new HttpParameter(name, String.valueOf(value)));
        }
    }

    String nextPage() {
        return this.nextPageQuery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query1 = (Query)o;
        if (this.maxId != query1.maxId) {
            return false;
        }
        if (this.count != query1.count) {
            return false;
        }
        if (this.sinceId != query1.sinceId) {
            return false;
        }
        if (this.geocode != null ? !this.geocode.equals(query1.geocode) : query1.geocode != null) {
            return false;
        }
        if (this.lang != null ? !this.lang.equals(query1.lang) : query1.lang != null) {
            return false;
        }
        if (this.locale != null ? !this.locale.equals(query1.locale) : query1.locale != null) {
            return false;
        }
        if (this.nextPageQuery != null ? !this.nextPageQuery.equals(query1.nextPageQuery) : query1.nextPageQuery != null) {
            return false;
        }
        if (this.query != null ? !this.query.equals(query1.query) : query1.query != null) {
            return false;
        }
        if (this.resultType != null ? !this.resultType.equals((Object)query1.resultType) : query1.resultType != null) {
            return false;
        }
        if (this.since != null ? !this.since.equals(query1.since) : query1.since != null) {
            return false;
        }
        return !(this.until != null ? !this.until.equals(query1.until) : query1.until != null);
    }

    public int hashCode() {
        int result2 = this.query != null ? this.query.hashCode() : 0;
        result2 = 31 * result2 + (this.lang != null ? this.lang.hashCode() : 0);
        result2 = 31 * result2 + (this.locale != null ? this.locale.hashCode() : 0);
        result2 = 31 * result2 + (int)(this.maxId ^ this.maxId >>> 32);
        result2 = 31 * result2 + this.count;
        result2 = 31 * result2 + (this.since != null ? this.since.hashCode() : 0);
        result2 = 31 * result2 + (int)(this.sinceId ^ this.sinceId >>> 32);
        result2 = 31 * result2 + (this.geocode != null ? this.geocode.hashCode() : 0);
        result2 = 31 * result2 + (this.until != null ? this.until.hashCode() : 0);
        result2 = 31 * result2 + (this.resultType != null ? this.resultType.hashCode() : 0);
        result2 = 31 * result2 + (this.nextPageQuery != null ? this.nextPageQuery.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "Query{query='" + this.query + '\'' + ", lang='" + this.lang + '\'' + ", locale='" + this.locale + '\'' + ", maxId=" + this.maxId + ", count=" + this.count + ", since='" + this.since + '\'' + ", sinceId=" + this.sinceId + ", geocode='" + this.geocode + '\'' + ", until='" + this.until + '\'' + ", resultType='" + (Object)((Object)this.resultType) + '\'' + ", nextPageQuery='" + this.nextPageQuery + '\'' + '}';
    }

    public static enum ResultType {
        popular,
        mixed,
        recent;

    }

    public static enum Unit {
        mi,
        km;

    }
}

