/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import twitter4j.HttpResponse;
import twitter4j.JSONArray;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.Status;
import twitter4j.StatusJSONImpl;
import twitter4j.TwitterException;
import twitter4j.TwitterObjectFactory;
import twitter4j.TwitterResponseImpl;
import twitter4j.conf.Configuration;

final class QueryResultJSONImpl
extends TwitterResponseImpl
implements QueryResult,
Serializable {
    private static final long serialVersionUID = -5359566235429947156L;
    private long sinceId;
    private long maxId;
    private String refreshUrl;
    private int count;
    private double completedIn;
    private String query;
    private List<Status> tweets;
    private String nextResults;

    QueryResultJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            JSONObject searchMetaData = json.getJSONObject("search_metadata");
            this.completedIn = ParseUtil.getDouble("completed_in", searchMetaData);
            this.count = ParseUtil.getInt("count", searchMetaData);
            this.maxId = ParseUtil.getLong("max_id", searchMetaData);
            this.nextResults = searchMetaData.has("next_results") ? searchMetaData.getString("next_results") : null;
            this.query = ParseUtil.getURLDecodedString("query", searchMetaData);
            this.refreshUrl = ParseUtil.getUnescapedString("refresh_url", searchMetaData);
            this.sinceId = ParseUtil.getLong("since_id", searchMetaData);
            JSONArray array = json.getJSONArray("statuses");
            this.tweets = new ArrayList<Status>(array.length());
            if (conf.isJSONStoreEnabled()) {
                TwitterObjectFactory.clearThreadLocalMap();
            }
            for (int i = 0; i < array.length(); ++i) {
                JSONObject tweet = array.getJSONObject(i);
                this.tweets.add(new StatusJSONImpl(tweet, conf));
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage() + ":" + json.toString(), jsone);
        }
    }

    QueryResultJSONImpl(Query query) {
        this.sinceId = query.getSinceId();
        this.count = query.getCount();
        this.tweets = new ArrayList<Status>(0);
    }

    @Override
    public long getSinceId() {
        return this.sinceId;
    }

    @Override
    public long getMaxId() {
        return this.maxId;
    }

    @Override
    public String getRefreshURL() {
        return this.refreshUrl;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public double getCompletedIn() {
        return this.completedIn;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public List<Status> getTweets() {
        return this.tweets;
    }

    @Override
    public Query nextQuery() {
        if (this.nextResults == null) {
            return null;
        }
        return Query.createWithNextPageQuery(this.nextResults);
    }

    @Override
    public boolean hasNext() {
        return this.nextResults != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryResult that = (QueryResult)o;
        if (Double.compare(that.getCompletedIn(), this.completedIn) != 0) {
            return false;
        }
        if (this.maxId != that.getMaxId()) {
            return false;
        }
        if (this.count != that.getCount()) {
            return false;
        }
        if (this.sinceId != that.getSinceId()) {
            return false;
        }
        if (!this.query.equals(that.getQuery())) {
            return false;
        }
        if (this.refreshUrl != null ? !this.refreshUrl.equals(that.getRefreshURL()) : that.getRefreshURL() != null) {
            return false;
        }
        return !(this.tweets != null ? !this.tweets.equals(that.getTweets()) : that.getTweets() != null);
    }

    public int hashCode() {
        int result2 = (int)(this.sinceId ^ this.sinceId >>> 32);
        result2 = 31 * result2 + (int)(this.maxId ^ this.maxId >>> 32);
        result2 = 31 * result2 + (this.refreshUrl != null ? this.refreshUrl.hashCode() : 0);
        result2 = 31 * result2 + this.count;
        long temp = this.completedIn != 0.0 ? Double.doubleToLongBits(this.completedIn) : 0L;
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        result2 = 31 * result2 + this.query.hashCode();
        result2 = 31 * result2 + (this.tweets != null ? this.tweets.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "QueryResultJSONImpl{sinceId=" + this.sinceId + ", maxId=" + this.maxId + ", refreshUrl='" + this.refreshUrl + '\'' + ", count=" + this.count + ", completedIn=" + this.completedIn + ", query='" + this.query + '\'' + ", tweets=" + this.tweets + '}';
    }
}

