/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;

public final class StallWarning
implements Serializable {
    private static final long serialVersionUID = -4294628635422470314L;
    private final String code;
    private final String message;
    private final int percentFull;

    StallWarning(JSONObject json) throws JSONException {
        JSONObject warning = json.getJSONObject("warning");
        this.code = ParseUtil.getRawString("code", warning);
        this.message = ParseUtil.getRawString("message", warning);
        this.percentFull = ParseUtil.getInt("percent_full", warning);
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public int getPercentFull() {
        return this.percentFull;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StallWarning that = (StallWarning)o;
        if (this.percentFull != that.percentFull) {
            return false;
        }
        if (this.code != null ? !this.code.equals(that.code) : that.code != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(that.message) : that.message != null);
    }

    public int hashCode() {
        int result2 = this.code != null ? this.code.hashCode() : 0;
        result2 = 31 * result2 + (this.message != null ? this.message.hashCode() : 0);
        result2 = 31 * result2 + this.percentFull;
        return result2;
    }

    public String toString() {
        return "StallWarning{code='" + this.code + '\'' + ", message='" + this.message + '\'' + ", percentFull=" + this.percentFull + '}';
    }
}

