/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.StatusDeletionNotice;

class StatusDeletionNoticeImpl
implements StatusDeletionNotice,
Serializable {
    private static final long serialVersionUID = 9144204870473786368L;
    private final long statusId;
    private final long userId;

    StatusDeletionNoticeImpl(JSONObject status) {
        this.statusId = ParseUtil.getLong("id", status);
        this.userId = ParseUtil.getLong("user_id", status);
    }

    @Override
    public long getStatusId() {
        return this.statusId;
    }

    @Override
    public long getUserId() {
        return this.userId;
    }

    @Override
    public int compareTo(StatusDeletionNotice that) {
        long delta = this.statusId - that.getStatusId();
        if (delta < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (delta > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)delta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusDeletionNoticeImpl that = (StatusDeletionNoticeImpl)o;
        if (this.statusId != that.statusId) {
            return false;
        }
        return this.userId == that.userId;
    }

    public int hashCode() {
        int result2 = (int)(this.statusId ^ this.statusId >>> 32);
        result2 = 31 * result2 + (int)(this.userId ^ this.userId >>> 32);
        return result2;
    }

    public String toString() {
        return "StatusDeletionNoticeImpl{statusId=" + this.statusId + ", userId=" + this.userId + '}';
    }
}

