/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.Trend;
import twitter4j.TwitterObjectFactory;

final class TrendJSONImpl
implements Trend,
Serializable {
    private static final long serialVersionUID = -4353426776065521132L;
    private final String name;
    private String url = null;
    private String query = null;

    TrendJSONImpl(JSONObject json, boolean storeJSON) {
        this.name = ParseUtil.getRawString("name", json);
        this.url = ParseUtil.getRawString("url", json);
        this.query = ParseUtil.getRawString("query", json);
        if (storeJSON) {
            TwitterObjectFactory.registerJSONObject(this, json);
        }
    }

    TrendJSONImpl(JSONObject json) {
        this(json, false);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Trend)) {
            return false;
        }
        Trend trend = (Trend)o;
        if (!this.name.equals(trend.getName())) {
            return false;
        }
        if (this.query != null ? !this.query.equals(trend.getQuery()) : trend.getQuery() != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(trend.getURL()) : trend.getURL() != null);
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = 31 * result2 + (this.url != null ? this.url.hashCode() : 0);
        result2 = 31 * result2 + (this.query != null ? this.query.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "TrendJSONImpl{name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", query='" + this.query + '\'' + '}';
    }
}

