/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.TwitterException;

public final class UploadedMedia
implements Serializable {
    private static final long serialVersionUID = 5393092535610604718L;
    private int imageWidth;
    private int imageHeight;
    private String imageType;
    private long mediaId;
    private long size;

    UploadedMedia(JSONObject json) throws TwitterException {
        this.init(json);
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public String getImageType() {
        return this.imageType;
    }

    public long getMediaId() {
        return this.mediaId;
    }

    public long getSize() {
        return this.size;
    }

    private void init(JSONObject json) throws TwitterException {
        this.mediaId = ParseUtil.getLong("media_id", json);
        this.size = ParseUtil.getLong("size", json);
        try {
            if (!json.isNull("image")) {
                JSONObject image = json.getJSONObject("image");
                this.imageWidth = ParseUtil.getInt("w", image);
                this.imageHeight = ParseUtil.getInt("h", image);
                this.imageType = ParseUtil.getUnescapedString("image_type", image);
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadedMedia that = (UploadedMedia)o;
        if (this.imageWidth != that.imageWidth) {
            return false;
        }
        if (this.imageHeight != that.imageHeight) {
            return false;
        }
        if (this.imageType != that.imageType) {
            return false;
        }
        if (this.mediaId != that.mediaId) {
            return false;
        }
        return this.size == that.size;
    }

    public int hashCode() {
        int result2 = (int)(this.mediaId ^ this.mediaId >>> 32);
        result2 = 31 * result2 + this.imageWidth;
        result2 = 31 * result2 + this.imageHeight;
        result2 = 31 * result2 + (this.imageType != null ? this.imageType.hashCode() : 0);
        result2 = 31 * result2 + (int)(this.size ^ this.size >>> 32);
        return result2;
    }

    public String toString() {
        return "UploadedMedia{mediaId=" + this.mediaId + ", imageWidth=" + this.imageWidth + ", imageHeight=" + this.imageHeight + ", imageType='" + this.imageType + '\'' + ", size=" + this.size + '}';
    }
}

