/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.insightedge;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Properties;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.LazyOpenInterpreter;
import org.apache.zeppelin.interpreter.WrappedInterpreter;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.spark.DepInterpreter;
import org.apache.zeppelin.spark.SparkInterpreter;
import org.insightedge.spark.utils.StringCompiler;
import scala.collection.Iterator;

public class CompilingInterpreter
extends Interpreter {
    private DepInterpreter depInterpreter;

    public CompilingInterpreter(Properties property) {
        super(property);
    }

    public void open() throws InterpreterException {
        this.depInterpreter = this.getDepInterpreter();
    }

    public void close() {
    }

    public Scheduler getScheduler() {
        Interpreter intp = this.getInterpreterInTheSameSessionByClassName(SparkInterpreter.class.getName());
        if (intp != null) {
            return intp.getScheduler();
        }
        return null;
    }

    public InterpreterResult interpret(String code, InterpreterContext context) {
        File outputFolder = null;
        try {
            outputFolder = Files.createTempDirectory("jars", new FileAttribute[0]).toFile();
        }
        catch (IOException up) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, "Cannot create temporary dir for compiled files");
        }
        StringCompiler compiler = new StringCompiler(outputFolder, StringCompiler.currentClassPath());
        boolean success = compiler.compile(code);
        if (!success) {
            Iterator iterator = compiler.getAndRemoveMessages().iterator();
            StringBuilder builder = new StringBuilder("Compilation failure");
            while (iterator.hasNext()) {
                builder.append("\n").append((String)iterator.next());
            }
            return new InterpreterResult(InterpreterResult.Code.ERROR, builder.toString());
        }
        File jar = compiler.packJar();
        String pathToJar = jar.getAbsolutePath().replace("\\", "\\\\");
        return this.depInterpreter.interpret("z.load(\"" + pathToJar + "\")", context);
    }

    public void cancel(InterpreterContext context) {
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context) {
        return 0;
    }

    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext context) {
        return this.depInterpreter.completion(buf, cursor);
    }

    private DepInterpreter getDepInterpreter() throws InterpreterException {
        LazyOpenInterpreter lazy = null;
        Interpreter p = this.getInterpreterInTheSameSessionByClassName(DepInterpreter.class.getName());
        while (p instanceof WrappedInterpreter) {
            if (p instanceof LazyOpenInterpreter) {
                lazy = (LazyOpenInterpreter)p;
            }
            p = ((WrappedInterpreter)p).getInnerInterpreter();
        }
        DepInterpreter dep = (DepInterpreter)p;
        if (lazy != null) {
            lazy.open();
        }
        return dep;
    }
}

