/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta;

import com.atomikos.icatch.Synchronization;
import com.atomikos.icatch.TxState;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;

class Sync2Sync
implements Synchronization {
    private static final Logger LOGGER = LoggerFactory.createLogger(Sync2Sync.class);
    protected javax.transaction.Synchronization sync_;
    private Boolean committed_;

    Sync2Sync(javax.transaction.Synchronization sync) {
        this.sync_ = sync;
    }

    public void beforeCompletion() {
        this.sync_.beforeCompletion();
        this.committed_ = null;
    }

    public void afterCompletion(Object state) {
        if (state.equals(TxState.TERMINATED)) {
            if (this.committed_ == null) {
                this.sync_.afterCompletion(5);
                LOGGER.logInfo("afterCompletion ( STATUS_UNKNOWN ) called  on Synchronization: " + this.sync_.toString());
            } else {
                boolean commit = this.committed_;
                if (commit) {
                    this.sync_.afterCompletion(3);
                    LOGGER.logInfo("afterCompletion ( STATUS_COMMITTED ) called  on Synchronization: " + this.sync_.toString());
                } else {
                    this.sync_.afterCompletion(4);
                    LOGGER.logInfo("afterCompletion ( STATUS_ROLLEDBACK ) called  on Synchronization: " + this.sync_.toString());
                }
            }
        } else if (state.equals(TxState.COMMITTING)) {
            this.committed_ = new Boolean(true);
        } else if (state.equals(TxState.ABORTING)) {
            this.committed_ = new Boolean(false);
        }
    }
}

