/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands;

import com.gigaspaces.cli.commands.GigaSpacesRestCommand;
import com.gigaspaces.cli.commands.XapPremiumMainCommand;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.RequestsApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.Request;
import java.util.logging.Level;
import org.gigaspaces.cli.CliCommandException;
import org.gigaspaces.cli.CliExecutor;

public abstract class AbstractAsynchronousCommand
extends GigaSpacesRestCommand {
    public static final String PROGRESS_INDICATOR = "\u00b7";
    protected int sleepCount;
    protected long startWaitingSuccessfulRequestTime;

    protected void execute() throws Exception {
        block13: {
            try {
                ApiResponse<String> response = this.runAsyncRequest();
                int responseStatusCode = response.getStatusCode();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("responseStatusCode=" + responseStatusCode);
                }
                if (responseStatusCode == 202) {
                    int statusCode;
                    Request request;
                    ApiResponse getIdResponse;
                    String responseData = (String)response.getData();
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("responseData=" + responseData);
                    }
                    this.sleepCount = 0;
                    this.startWaitingSuccessfulRequestTime = System.currentTimeMillis();
                    while (true) {
                        getIdResponse = new RequestsApi().requestsIdGetWithHttpInfo(responseData);
                        request = (Request)getIdResponse.getData();
                        Request.StatusEnum status = request.getStatus();
                        statusCode = getIdResponse.getStatusCode();
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.finest("statusCode=" + statusCode + ", status=" + status);
                        }
                        if (statusCode != 200) break;
                        if (status == Request.StatusEnum.SUCCESSFUL) {
                            this.handleWaiting(request, (ApiResponse<Request>)getIdResponse, true);
                            this.printSuccessfulResultMessage(request);
                        } else if (!this.handleWaiting(request, (ApiResponse<Request>)getIdResponse, true)) {
                            if (status == Request.StatusEnum.FAILED) {
                                String message = request.getDescription() + " - " + request.getStatus() + (request.getError() == null ? "" : " - " + request.getError());
                                throw new CliCommandException(message).exitCode(1);
                            }
                            if (!this.handleWaiting(request, (ApiResponse<Request>)getIdResponse, false)) {
                                Thread.currentThread();
                                Thread.sleep(500L);
                                ++this.sleepCount;
                                continue;
                            }
                        }
                        break block13;
                        break;
                    }
                    Exception exception = CliManagerUtils.getHttpFailureException(getIdResponse);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "#" + statusCode + " \u00b7 " + exception.getLocalizedMessage() + "\n" + request, exception);
                    }
                    throw exception;
                }
                throw CliManagerUtils.getHttpFailureException(response);
            }
            catch (ApiException e) {
                throw CliManagerUtils.createThrownException((Exception)((Object)e));
            }
        }
    }

    protected boolean handleWaiting(Request request, ApiResponse<Request> getIdResponse, boolean forcePrintProgress) throws CliCommandException {
        if (System.currentTimeMillis() - this.startWaitingSuccessfulRequestTime > (long)(this.getWaitingTimeout() * 1000)) {
            return this.handleTimeout(request);
        }
        if (this.sleepCount % 5 == 0) {
            System.out.print(PROGRESS_INDICATOR);
        }
        return false;
    }

    protected boolean handleTimeout(Request request) throws CliCommandException {
        String message = "Operation timeout after " + this.getWaitingTimeout() + " seconds. ";
        String requestUrl = CliManagerUtils.getRestBasePath() + "/requests/" + request.getId();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(message + "\n- Request URL: " + requestUrl + "\n- Request response: " + request);
        } else {
            System.err.println(message + "\n- Request URL: " + requestUrl + "\n- Status  URL: " + request.getStatusUrl());
        }
        throw new CliCommandException(message + "Request URL: " + requestUrl).exitCode(1);
    }

    protected int getWaitingTimeout() {
        XapPremiumMainCommand mainCommand = (XapPremiumMainCommand)((Object)CliExecutor.getMainCommand().getCommand());
        return mainCommand.timeout;
    }

    protected abstract void printSuccessfulResultMessage(Request var1);

    protected abstract ApiResponse<String> runAsyncRequest() throws ApiException;
}

