/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands;

import com.gigaspaces.cli.commands.host.HostRunAgentCommand;
import com.gigaspaces.cli.commands.space.SpaceDeployProcessBuilderWrapper;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.start.manager.XapManagerClusterInfo;
import com.gigaspaces.start.manager.XapManagerConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.gigaspaces.cli.CliCommand;
import org.gigaspaces.cli.commands.XapMainCommand;
import org.gigaspaces.cli.commands.utils.ProcessBuilderWrapper;
import org.gigaspaces.cli.commands.utils.XapCliUtils;
import picocli.CommandLine;

@CommandLine.Command(name="demo", header={"Deploy a Space in high availability mode (2 primaries with 1 backup each)"})
public class DemoCommand
extends CliCommand {
    protected boolean auto = true;

    protected void execute() throws Exception {
        this.verifyXapManagerConfiguration();
        HostRunAgentCommand hostRunAgentCommand = new HostRunAgentCommand();
        hostRunAgentCommand.setAuto(this.auto);
        hostRunAgentCommand.setGscs(4);
        ProcessBuilder runAgentProcessBuilder = hostRunAgentCommand.createProcessBuilder();
        ArrayList<ProcessBuilderWrapper> processBuilderList = new ArrayList<ProcessBuilderWrapper>(2);
        processBuilderList.add(new ProcessBuilderWrapper(runAgentProcessBuilder));
        processBuilderList.add(new SpaceDeployProcessBuilderWrapper(this.runSpaceDeployCommand("demo")));
        XapCliUtils.executeProcessesWrapper(processBuilderList);
    }

    protected ProcessBuilder runSpaceDeployCommand(String spaceName) throws Exception {
        String spaceDeployCommand = "space deploy --partitions=2 --ha " + spaceName;
        String scriptHome = SystemInfo.singleton().locations().bin();
        String suffix = XapMainCommand.isXapNet() ? ".exe" : (SystemInfo.singleton().os().isWindows() ? ".bat" : "");
        String command = scriptHome + File.separator + "xap" + suffix + " " + spaceDeployCommand;
        String[] args = command.split(" ");
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        processBuilder.redirectErrorStream(true);
        processBuilder.directory(new File(scriptHome));
        processBuilder.inheritIO();
        return processBuilder;
    }

    protected void verifyXapManagerConfiguration() {
        boolean serversConfigured;
        XapManagerClusterInfo xapManagerClusterInfo = SystemInfo.singleton().getManagerClusterInfo();
        boolean bl = serversConfigured = xapManagerClusterInfo.getServers().length != 0;
        if (serversConfigured) {
            boolean onManagerMachine = xapManagerClusterInfo.getCurrServer() != null;
            boolean managerFound = this.pingXapManagers();
            if (managerFound) {
                this.auto = false;
            } else if (!onManagerMachine) {
                System.err.println("Demo command cannot be run.\nXAP_MANAGER_SERVERS is configured,\nBut no running managers were found in the locations specified.\nTo run a demo on this machine:\nUnset the XAP_MANAGER_SERVERS environment variable.\n");
                System.exit(1);
            }
        }
    }

    private boolean pingXapManagers() {
        XapManagerConfig[] servers = SystemInfo.singleton().getManagerClusterInfo().getServers();
        if (servers.length > 0) {
            for (XapManagerConfig server : servers) {
                try {
                    String url = server.getAdminRestUrl() + "/v2";
                    if (CliManagerUtils.pingUrl(url)) {
                        return true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

