/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands;

import com.gigaspaces.cli.commands.XapPremiumMainCommand;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.invoker.ApiClient;
import com.gigaspaces.rest.client.java.invoker.Configuration;
import com.squareup.okhttp.OkHttpClient;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.gigaspaces.cli.CliCommand;
import org.gigaspaces.cli.CliExecutor;

public abstract class GigaSpacesRestCommand
extends CliCommand {
    protected void beforeExecute() {
        ApiClient apiClient;
        String basePath;
        block9: {
            String debugProperty;
            super.beforeExecute();
            basePath = CliManagerUtils.getRestBasePath();
            apiClient = Configuration.getDefaultApiClient();
            String timeoutProperty = System.getProperty("com.gs.rest.client.http.timeout", String.valueOf(0));
            if (timeoutProperty != null) {
                int timeout = Integer.parseInt(timeoutProperty);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Setting http client timeout:" + timeout + " seconds");
                }
                apiClient.getHttpClient().setReadTimeout((long)timeout, TimeUnit.SECONDS);
                apiClient.getHttpClient().setConnectTimeout((long)timeout, TimeUnit.SECONDS);
            }
            if ((debugProperty = System.getProperty("com.gs.rest.client.debug.enabled", String.valueOf(false))) != null) {
                boolean isDebugEnabled = Boolean.parseBoolean(debugProperty);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Setting client debugging enabled: " + isDebugEnabled);
                }
                apiClient.setDebugging(isDebugEnabled);
            }
            XapPremiumMainCommand mainCommand = (XapPremiumMainCommand)((Object)CliExecutor.getMainCommand().getCommand());
            String username = mainCommand.username;
            if (username != null) {
                String password = mainCommand.password;
                apiClient.setUsername(username);
                if (password != null) {
                    apiClient.setPassword(password);
                }
            }
            if (Boolean.getBoolean("com.gs.manager.rest.ssl.enabled")) {
                try {
                    this.applySslConfigurations(apiClient.getHttpClient());
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block9;
                    LOGGER.log(Level.SEVERE, "Failed to apply SSL configuration", e);
                }
            }
        }
        apiClient.setBasePath(basePath);
    }

    private void applySslConfigurations(OkHttpClient httpClient) throws Exception {
        httpClient.setSslSocketFactory(this.createSSLSocketFactory());
        httpClient.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }

    private SSLSocketFactory createSSLSocketFactory() throws Exception {
        SSLContext trustAllSslContext = SSLContext.getInstance("SSL");
        TrustManager[] trustAllCerts = this.createTrustManagers();
        trustAllSslContext.init(null, trustAllCerts, new SecureRandom());
        return trustAllSslContext.getSocketFactory();
    }

    private TrustManager[] createTrustManagers() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        return trustAllCerts;
    }
}

