/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands;

import com.gigaspaces.cli.commands.GigaSpacesRestCommand;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.InformationApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.EnvironmentInfo;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="info", header={"Show the configured Manager information"})
public class InfoCommand
extends GigaSpacesRestCommand {
    public static final String HEADER_INFO_DETAILS = "INFO";
    private static final String LINE_FORMAT = "%-16s %s%n";

    protected void execute() throws Exception {
        try {
            ApiResponse response = new InformationApi().infoGetWithHttpInfo();
            if (response.getStatusCode() != 200) {
                throw CliManagerUtils.getHttpFailureException(response);
            }
            EnvironmentInfo data = (EnvironmentInfo)response.getData();
            String lookupGroups = data.getLookupGroups();
            List managers = data.getManagers();
            String revision = data.getRevision();
            String startedOn = data.getStartedOn();
            String version = data.getVersion();
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append(System.lineSeparator());
            strBuilder.append(HEADER_INFO_DETAILS);
            strBuilder.append(System.lineSeparator());
            strBuilder.append(String.format(LINE_FORMAT, "Lookups Groups", lookupGroups));
            strBuilder.append(String.format(LINE_FORMAT, "Managers", CliManagerUtils.getObjectsTextPresentation(managers)));
            strBuilder.append(String.format(LINE_FORMAT, "Revision", revision));
            strBuilder.append(String.format(LINE_FORMAT, "Started On", startedOn));
            strBuilder.append(String.format(LINE_FORMAT, "Version", version));
            System.out.println(strBuilder);
        }
        catch (ApiException e) {
            throw CliManagerUtils.createThrownException((Exception)((Object)e));
        }
    }
}

