/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.container;

import com.gigaspaces.cli.commands.AbstractAsynchronousCommand;
import com.gigaspaces.rest.client.java.api.ContainersApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.CreateContainerRequest;
import com.gigaspaces.rest.client.java.model.Request;
import com.gigaspaces.start.SystemInfo;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import picocli.CommandLine;

@CommandLine.Command(name="create", header={"Create a new container"})
public class ContainerCreateCommand
extends AbstractAsynchronousCommand {
    @CommandLine.Option(names={"--memory"}, description={"Container's JVM max memory"})
    String memory;
    @CommandLine.Option(names={"--zone"}, description={"Container's zone"})
    String zone;
    @CommandLine.Option(names={"--property"}, description={"Additional System properties"})
    Map<String, String> properties;
    @CommandLine.Parameters(index="0", description={"Host to create container on"})
    String host;

    private CreateContainerRequest createContainerRequest() {
        CreateContainerRequest createContainerRequest = new CreateContainerRequest();
        if (this.host.equals("localhost")) {
            this.host = SystemInfo.singleton().network().getHost().getHostName();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("'localhost' resolved to " + this.host);
            }
        }
        createContainerRequest.setHost(this.host);
        createContainerRequest.setMemory(this.memory);
        createContainerRequest.setZone(this.zone);
        if (this.properties != null) {
            Set<Map.Entry<String, String>> entries = this.properties.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                createContainerRequest.addVmArgumentsItem("-D" + entry.getKey() + "=" + entry.getValue());
            }
        }
        return createContainerRequest;
    }

    @Override
    protected void printSuccessfulResultMessage(Request responseData) {
        String statusUrl = responseData.getStatusUrl();
        System.out.println("\nContainer [" + statusUrl.substring(statusUrl.lastIndexOf(47) + 1) + "] was successfully created at " + responseData.getCompletedAt());
    }

    @Override
    protected ApiResponse<String> runAsyncRequest() throws ApiException {
        ContainersApi containersApi = new ContainersApi();
        CreateContainerRequest createContainerRequest = this.createContainerRequest();
        ApiResponse response = containersApi.containersPostWithHttpInfo(createContainerRequest);
        return response;
    }
}

