/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.container;

import com.gigaspaces.cli.commands.GigaSpacesRestCommand;
import com.gigaspaces.cli.commands.output.ConsoleOutput;
import com.gigaspaces.cli.commands.output.Output;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.ContainersApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.JvmDetails;
import com.gigaspaces.rest.client.java.model.JvmStatistics;
import com.gigaspaces.rest.client.java.model.ProcessingUnitInstanceContainer;
import com.gigaspaces.rest.client.java.model.TransportDetails;
import com.gigaspaces.rest.client.java.model.TransportStatistics;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import picocli.CommandLine;

@CommandLine.Command(name="info", header={"Show information for the specified container"})
public class ContainerInfoCommand
extends GigaSpacesRestCommand {
    @CommandLine.Parameters(paramLabel="<container ID>", index="0", description={"ID of the required container"})
    String containerId;
    @CommandLine.Option(names={"--jvm"}, description={"Show the virtual machine details"})
    boolean jvm;
    @CommandLine.Option(names={"--jvm_stats"}, description={"Show the virtual machine statistics"})
    boolean jvm_stats;
    @CommandLine.Option(names={"--network"}, description={"Show the network details"})
    boolean network;
    @CommandLine.Option(names={"--network_stats"}, description={"Show the network statistics"})
    boolean network_stats;
    public static final String HEADER_CONTAINER_DETAILS = "CONTAINER DETAILS";
    public static final String HEADER_JVM_DETAILS = "JVM DETAILS";
    public static final String HEADER_JVM_STATS = "JVM STATISTICS";
    public static final String HEADER_NETWORK_DETAILS = "NETWORK DETAILS";
    public static final String HEADER_NETWORK_STATS = "NETWORK STATISTICS";

    protected void execute() throws Exception {
        block7: {
            try {
                ContainersApi containersApi = new ContainersApi();
                ApiResponse processingUnitInstanceContainerApiResponse = containersApi.containersIdGetWithHttpInfo(this.containerId);
                if (processingUnitInstanceContainerApiResponse.getStatusCode() == 200) {
                    this.printContainerDetails((ApiResponse<ProcessingUnitInstanceContainer>)processingUnitInstanceContainerApiResponse);
                    if (this.jvm) {
                        ApiResponse jvmDetailsApiResponse = containersApi.containersIdDetailsJvmGetWithHttpInfo(this.containerId);
                        this.printJvmDetails((ApiResponse<JvmDetails>)jvmDetailsApiResponse);
                    }
                    if (this.jvm_stats) {
                        ApiResponse jvmStatisticsApiResponse = containersApi.containersIdStatisticsJvmGetWithHttpInfo(this.containerId);
                        this.printJvmStatistics((ApiResponse<JvmStatistics>)jvmStatisticsApiResponse);
                    }
                    if (this.network) {
                        ApiResponse transportDetailsApiResponse = containersApi.containersIdDetailsTransportGetWithHttpInfo(this.containerId);
                        this.printTransportDetails((ApiResponse<TransportDetails>)transportDetailsApiResponse);
                    }
                    if (this.network_stats) {
                        ApiResponse transportStatisticsApiResponse = containersApi.containersIdStatisticsTransportGetWithHttpInfo(this.containerId);
                        this.printTransportStatistics((ApiResponse<TransportStatistics>)transportStatisticsApiResponse);
                    }
                    break block7;
                }
                throw CliManagerUtils.getHttpFailureException(processingUnitInstanceContainerApiResponse);
            }
            catch (ApiException e) {
                throw CliManagerUtils.createThrownException((Exception)((Object)e));
            }
        }
    }

    private void printContainerDetails(ApiResponse<ProcessingUnitInstanceContainer> processingUnitInstanceContainerApiResponse) {
        ProcessingUnitInstanceContainer data = (ProcessingUnitInstanceContainer)processingUnitInstanceContainerApiResponse.getData();
        long pid = data.getPid().intValue();
        String id = data.getId();
        List processingUnitInstances = data.getInstances();
        String zones = CliManagerUtils.getZonesPresentation(data);
        Output output = new Output();
        output.addColumn(HEADER_CONTAINER_DETAILS);
        output.addRow("ID", id);
        output.addRow("PID", String.valueOf(pid));
        output.addRow("Zones", zones);
        output.addRow("Processing Unit instances", processingUnitInstances.isEmpty() ? Output.EMPTY : (String)processingUnitInstances.get(0));
        int processingUnitInstancesCount = processingUnitInstances.size();
        for (int i = 1; i < processingUnitInstancesCount; ++i) {
            output.addRow(Output.EMPTY, (String)processingUnitInstances.get(i));
        }
        ConsoleOutput.println(output);
    }

    private void printJvmDetails(ApiResponse<JvmDetails> jvmDetailsApiResponse) throws Exception {
        if (jvmDetailsApiResponse.getStatusCode() != 200) {
            throw CliManagerUtils.getHttpFailureException(jvmDetailsApiResponse);
        }
        JvmDetails jvmDetails = (JvmDetails)jvmDetailsApiResponse.getData();
        String bootClassPath = jvmDetails.getBootClassPath();
        String classPath = jvmDetails.getClassPath();
        List inputArguments = jvmDetails.getInputArguments();
        Map environmentVariables = jvmDetails.getEnvironmentVariables();
        Map systemProperties = jvmDetails.getSystemProperties();
        String vmName = jvmDetails.getVmName();
        String vmVendor = jvmDetails.getVmVendor();
        String vmVersion = jvmDetails.getVmVersion();
        String jmxUrl = jvmDetails.getJmxUrl();
        Long memoryHeapInitInBytes = jvmDetails.getMemoryHeapInitInBytes();
        Long memoryNonHeapInitInBytes = jvmDetails.getMemoryNonHeapInitInBytes();
        Long memoryNonHeapMaxInBytes = jvmDetails.getMemoryNonHeapMaxInBytes();
        String printMemoryNonHeapMaxInBytes = CliManagerUtils.ifMinusOneReturnNA(memoryNonHeapMaxInBytes);
        Long startTime = jvmDetails.getStartTime();
        Long memoryHeapMaxInBytes = jvmDetails.getMemoryHeapMaxInBytes();
        String startTimePresentation = this.createStartTimePresentation(startTime);
        Output output = new Output();
        output.addColumn(HEADER_JVM_DETAILS);
        output.addRow("VM Name", vmName);
        output.addRow("VM Vendor", vmVendor);
        output.addRow("VM Version", vmVersion);
        output.addRow("JMX URL", jmxUrl);
        output.addRow("Memory Heap Max", CliManagerUtils.formatLongValue(memoryHeapMaxInBytes));
        output.addRow("Memory Heap Init", CliManagerUtils.formatLongValue(memoryHeapInitInBytes));
        output.addRow("Memory Non Heap Init", CliManagerUtils.formatLongValue(memoryNonHeapInitInBytes));
        output.addRow("Memory Non Heap Max", printMemoryNonHeapMaxInBytes);
        output.addRow("Start Time", startTimePresentation);
        Output classpathOutput = new Output();
        classpathOutput.addRow("Classpath", classPath);
        Output bootClasspathOutput = new Output();
        bootClasspathOutput.addRow("Boot Classpath", bootClassPath);
        Output inputArgumentsOutput = new Output();
        inputArgumentsOutput.addRow("Input Arguments", Arrays.toString(inputArguments.toArray(new String[inputArguments.size()])));
        Output envVariablesOutput = new Output();
        envVariablesOutput.addRow("Environment Variables", Arrays.toString(environmentVariables.entrySet().toArray()));
        Output systemPropertiesOutput = new Output();
        systemPropertiesOutput.addRow("System Properties", Arrays.toString(systemProperties.entrySet().toArray()));
        ConsoleOutput.print(output);
        ConsoleOutput.print(classpathOutput);
        ConsoleOutput.print(bootClasspathOutput);
        ConsoleOutput.print(inputArgumentsOutput);
        ConsoleOutput.print(envVariablesOutput);
        ConsoleOutput.println(systemPropertiesOutput);
    }

    private String createStartTimePresentation(long startTime) {
        DateFormat df = DateFormat.getDateTimeInstance(2, 2);
        return df.format(new Date(startTime));
    }

    private void printJvmStatistics(ApiResponse<JvmStatistics> jvmStatisticsApiResponse) throws Exception {
        if (jvmStatisticsApiResponse.getStatusCode() != 200) {
            throw CliManagerUtils.getHttpFailureException(jvmStatisticsApiResponse);
        }
        JvmStatistics jvmStatistics = (JvmStatistics)jvmStatisticsApiResponse.getData();
        Long gcCount = jvmStatistics.getGcCount();
        Long gcTime = jvmStatistics.getGcTime();
        Long memoryHeapCommittedInBytes = jvmStatistics.getMemoryHeapCommittedInBytes();
        Long memoryHeapUsedInBytes = jvmStatistics.getMemoryHeapUsedInBytes();
        Long memoryNonHeapCommittedInBytes = jvmStatistics.getMemoryNonHeapCommittedInBytes();
        Long memoryNonHeapUsedInBytes = jvmStatistics.getMemoryNonHeapUsedInBytes();
        Integer peakThreadCount = jvmStatistics.getPeakThreadCount();
        Integer threadCount = jvmStatistics.getThreadCount();
        Long uptime = jvmStatistics.getUptime();
        Output output = new Output();
        output.addColumn(HEADER_JVM_STATS);
        output.addRow("GC Count", CliManagerUtils.formatLongValue(gcCount));
        output.addRow("GC Time", CliManagerUtils.formatLongValue(gcTime));
        output.addRow("Memory Heap Committed", CliManagerUtils.formatLongValue(memoryHeapCommittedInBytes));
        output.addRow("Memory Heap Used", CliManagerUtils.formatLongValue(memoryHeapUsedInBytes));
        output.addRow("Memory Non Heap Committed", CliManagerUtils.formatLongValue(memoryNonHeapCommittedInBytes));
        output.addRow("Memory Non Heap Used", CliManagerUtils.formatLongValue(memoryNonHeapUsedInBytes));
        output.addRow("Peak Thread Count", String.valueOf(peakThreadCount));
        output.addRow("Thread Count", String.valueOf(threadCount));
        output.addRow("Uptime", CliManagerUtils.createDurationPresentation(uptime));
        ConsoleOutput.println(output);
    }

    private void printTransportDetails(ApiResponse<TransportDetails> transportDetailsApiResponse) throws Exception {
        if (transportDetailsApiResponse.getStatusCode() != 200) {
            throw CliManagerUtils.getHttpFailureException(transportDetailsApiResponse);
        }
        TransportDetails transportDetails = (TransportDetails)transportDetailsApiResponse.getData();
        String bindHost = transportDetails.getBindHost();
        String hostAddress = transportDetails.getHostAddress();
        String hostName = transportDetails.getHostName();
        Boolean isSslEnabled = transportDetails.isIsSslEnabled();
        Integer maxThreads = transportDetails.getMaxThreads();
        Integer minThreads = transportDetails.getMinThreads();
        Integer port = transportDetails.getPort();
        Output output = new Output();
        output.addColumn(HEADER_NETWORK_DETAILS);
        output.addRow("Bind Host", bindHost);
        output.addRow("Host Address", hostAddress);
        output.addRow("Host Name", hostName);
        output.addRow("SSL Enabled", String.valueOf(isSslEnabled));
        output.addRow("Max Threads", String.valueOf(maxThreads));
        output.addRow("Min Threads", String.valueOf(minThreads));
        output.addRow("Port", String.valueOf(port));
        ConsoleOutput.println(output);
    }

    private void printTransportStatistics(ApiResponse<TransportStatistics> transportStatisticsApiResponse) throws Exception {
        if (transportStatisticsApiResponse.getStatusCode() != 200) {
            throw CliManagerUtils.getHttpFailureException(transportStatisticsApiResponse);
        }
        TransportStatistics transportStatistics = (TransportStatistics)transportStatisticsApiResponse.getData();
        Integer activeThreadsCount = transportStatistics.getActiveThreadsCount();
        Double activeThreadsPerc = transportStatistics.getActiveThreadsPerc();
        Long completedTaskCount = transportStatistics.getCompletedTaskCount();
        Double completedTaskPerSecond = transportStatistics.getCompletedTaskPerSecond();
        Integer queueSize = transportStatistics.getQueueSize();
        Output output = new Output();
        output.addColumn(HEADER_NETWORK_STATS);
        output.addRow("Active Threads Count", String.valueOf(activeThreadsCount));
        output.addRow("Active Threads Perc.", String.valueOf(activeThreadsPerc));
        output.addRow("Completed Task Count", CliManagerUtils.formatLongValue(completedTaskCount));
        output.addRow("Completed Task/Second", CliManagerUtils.formatDecimalValue(completedTaskPerSecond));
        output.addRow("Queue Size", String.valueOf(queueSize));
        ConsoleOutput.println(output);
    }
}

