/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.container;

import com.gigaspaces.cli.commands.AbstractAsynchronousCommand;
import com.gigaspaces.rest.client.java.api.ContainersApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.Request;
import picocli.CommandLine;

@CommandLine.Command(name="kill", header={"Kill specified container"})
public class ContainerKillCommand
extends AbstractAsynchronousCommand {
    @CommandLine.Parameters(paramLabel="<container ID>", index="0", description={"Container to kill"})
    String containerId;

    @Override
    protected void printSuccessfulResultMessage(Request responseData) {
        System.out.println("\nContainer [" + this.containerId + "] was killed at " + responseData.getCompletedAt());
    }

    @Override
    protected ApiResponse<String> runAsyncRequest() throws ApiException {
        ContainersApi containersApi = new ContainersApi();
        ApiResponse killContainerResponse = containersApi.containersIdDeleteWithHttpInfo(this.containerId);
        return killContainerResponse;
    }
}

