/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.container;

import com.gigaspaces.cli.commands.GigaSpacesRestCommand;
import com.gigaspaces.cli.commands.output.ConsoleOutput;
import com.gigaspaces.cli.commands.output.Output;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.ContainersApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.ProcessingUnitInstanceContainer;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="list", header={"Lists all containers"})
public class ContainerListCommand
extends GigaSpacesRestCommand {
    private static final String[] headersList = new String[]{"Container ID", "PID", "Zones", "Processing Units Instances"};

    protected void execute() throws Exception {
        try {
            int totalInstances;
            Output output;
            List responseData;
            ApiResponse response = new ContainersApi().containersGetWithHttpInfo();
            if (response.getStatusCode() == 200) {
                responseData = (List)response.getData();
                output = new Output();
                output.addColumns(headersList);
                totalInstances = 0;
                for (ProcessingUnitInstanceContainer container : responseData) {
                    List instances = container.getInstances();
                    String firstInstanceId = instances.isEmpty() ? Output.EMPTY : (String)instances.get(0);
                    output.addRow(container.getId(), String.valueOf(container.getPid()), CliManagerUtils.getZonesPresentation(container), firstInstanceId);
                    for (int i = 1; i < instances.size(); ++i) {
                        output.addRow(Output.EMPTY, Output.EMPTY, Output.EMPTY, (String)instances.get(i));
                    }
                    totalInstances += instances.size();
                }
            } else {
                throw CliManagerUtils.getHttpFailureException(response);
            }
            ConsoleOutput.newline();
            ConsoleOutput.println(output);
            Output sumOutput = new Output();
            sumOutput.addColumn("SUMMARY");
            sumOutput.addRow("Containers:", String.valueOf(responseData.size())).addRow("Instances:", String.valueOf(totalInstances));
            ConsoleOutput.newline();
            ConsoleOutput.println(sumOutput);
        }
        catch (ApiException e) {
            throw CliManagerUtils.createThrownException((Exception)((Object)e));
        }
    }
}

