/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.container;

import com.gigaspaces.cli.commands.AbstractAsynchronousCommand;
import com.gigaspaces.rest.client.java.api.ContainersApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.Request;
import picocli.CommandLine;

@CommandLine.Command(name="restart", header={"Restart the specified container"})
public class ContainerRestartCommand
extends AbstractAsynchronousCommand {
    @CommandLine.Parameters(paramLabel="<container ID>", index="0", description={"Container to restart"})
    String containerId;

    @Override
    protected void printSuccessfulResultMessage(Request responseData) {
        String statusUrl = responseData.getStatusUrl();
        System.out.println("\nContainer [" + this.containerId + "] was successfully restarted at " + responseData.getCompletedAt() + " and become [" + statusUrl.substring(statusUrl.lastIndexOf(47) + 1) + "]");
    }

    @Override
    protected ApiResponse<String> runAsyncRequest() throws ApiException {
        ContainersApi containersApi = new ContainersApi();
        ApiResponse restartContainerResponse = containersApi.containersIdRestartPostWithHttpInfo(this.containerId);
        return restartContainerResponse;
    }
}

