/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.host;

import com.gigaspaces.cli.commands.GigaSpacesRestCommand;
import com.gigaspaces.cli.commands.output.ConsoleOutput;
import com.gigaspaces.cli.commands.output.Output;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.HostsApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.Host;
import com.gigaspaces.rest.client.java.model.OperatingSystemDetails;
import com.gigaspaces.rest.client.java.model.OperatingSystemStatistics;
import com.gigaspaces.rest.client.java.model.ProcessingUnitInstanceContainer;
import com.gigaspaces.start.SystemInfo;
import java.util.List;
import java.util.logging.Level;
import picocli.CommandLine;

@CommandLine.Command(name="info", header={"Show information for the specified host"})
public class HostInfoCommand
extends GigaSpacesRestCommand {
    @CommandLine.Parameters(index="0", description={"Name (or IP address) of the host"})
    String name;
    @CommandLine.Option(names={"--os"}, description={"Show the operating system details"})
    boolean os;
    @CommandLine.Option(names={"--os-stats"}, description={"Show the operating system statistics"})
    boolean osStats;
    @CommandLine.Option(names={"--containers"}, description={"Show details of containers running on host"})
    boolean containers;
    public static final String HEADER_HOST_DETAILS = "HOST DETAILS";
    public static final String HEADER_OS_DETAILS = "OPERATING SYSTEM DETAILS";
    public static final String HEADER_OS_STATS = "OPERATING SYSTEM STATISTICS";
    public static final String HEADER_CONTAINERS = "CONTAINERS";

    protected void execute() throws Exception {
        block8: {
            try {
                HostsApi hostsApi;
                ApiResponse response;
                if (this.name.equals("localhost")) {
                    this.name = SystemInfo.singleton().network().getHost().getHostName();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("'localhost' resolved to " + this.name);
                    }
                }
                if ((response = (hostsApi = new HostsApi()).hostsIdGetWithHttpInfo(this.name)).getStatusCode() == 200) {
                    this.printHostDetails((ApiResponse<Host>)response);
                    if (this.os) {
                        ApiResponse operatingSystemDetailsApiResponse = hostsApi.hostsIdDetailsOsGetWithHttpInfo(this.name);
                        this.printOperatingSystemDetails((ApiResponse<OperatingSystemDetails>)operatingSystemDetailsApiResponse);
                    }
                    if (this.osStats) {
                        ApiResponse operatingSystemStatisticsApiResponse = hostsApi.hostsIdStatisticsOsGetWithHttpInfo(this.name);
                        this.printOperatingSystemStatistics((ApiResponse<OperatingSystemStatistics>)operatingSystemStatisticsApiResponse);
                    }
                    if (this.containers) {
                        ApiResponse listApiResponse = hostsApi.hostsIdContainersGetWithHttpInfo(this.name);
                        this.printContainers((ApiResponse<List<ProcessingUnitInstanceContainer>>)listApiResponse);
                    }
                    break block8;
                }
                throw CliManagerUtils.getHttpFailureException(response);
            }
            catch (ApiException e) {
                throw CliManagerUtils.createThrownException((Exception)((Object)e));
            }
        }
    }

    private void printHostDetails(ApiResponse<Host> response) {
        Host data = (Host)response.getData();
        String name = data.getName();
        String address = data.getAddress();
        List containers = data.getContainers();
        Output output = new Output();
        output.addColumn(HEADER_HOST_DETAILS);
        output.addRow("Name", name);
        output.addRow("Address", address);
        output.addRow("Containers", containers.isEmpty() ? Output.EMPTY : (String)containers.get(0));
        int containersCount = containers.size();
        for (int containerIndex = 1; containerIndex < containersCount; ++containerIndex) {
            output.addRow(Output.EMPTY, (String)containers.get(containerIndex));
        }
        ConsoleOutput.newline();
        ConsoleOutput.print(output);
    }

    private void printContainers(ApiResponse<List<ProcessingUnitInstanceContainer>> listApiResponse) {
        List container = (List)listApiResponse.getData();
        Output output = new Output();
        output.addColumn(HEADER_CONTAINERS);
        int size = container.size();
        output.addRow("Containers Count", String.valueOf(size));
        for (int index = 0; index < size; ++index) {
            ProcessingUnitInstanceContainer processingUnitInstanceContainer = (ProcessingUnitInstanceContainer)container.get(index);
            String id = processingUnitInstanceContainer.getId();
            Integer pid = processingUnitInstanceContainer.getPid();
            List processingUnitInstances = processingUnitInstanceContainer.getInstances();
            output.addRow("ID", id);
            output.addRow("PID", String.valueOf(pid));
            output.addRow("Zones", CliManagerUtils.getZonesPresentation(processingUnitInstanceContainer));
            output.addRow("PU Instances", processingUnitInstances.isEmpty() ? Output.EMPTY : (String)processingUnitInstances.get(0));
            int processingUnitsCount = processingUnitInstances.size();
            for (int processingUnitsIndex = 1; processingUnitsIndex < processingUnitsCount; ++processingUnitsIndex) {
                output.addRow(Output.EMPTY, (String)processingUnitInstances.get(processingUnitsIndex));
            }
        }
        ConsoleOutput.newline();
        ConsoleOutput.print(output);
    }

    private void printOperatingSystemStatistics(ApiResponse<OperatingSystemStatistics> operatingSystemStatisticsApiResponse) {
        OperatingSystemStatistics osStatistics = (OperatingSystemStatistics)operatingSystemStatisticsApiResponse.getData();
        String cpuPercFormatted = osStatistics.getCpuPercFormatted();
        Long actualFreePhysicalMemorySizeInBytes = osStatistics.getActualFreePhysicalMemorySizeInBytes();
        Long actualMemoryUsed = osStatistics.getActualMemoryUsed();
        Long freePhysicalMemorySizeInBytes = osStatistics.getFreePhysicalMemorySizeInBytes();
        Long freeSwapSpaceSizeInBytes = osStatistics.getFreeSwapSpaceSizeInBytes();
        Double physicalMemoryUsedPerc = osStatistics.getPhysicalMemoryUsedPerc();
        Output output = new Output();
        output.addColumn(HEADER_OS_STATS);
        output.addRow("Cpu", cpuPercFormatted);
        output.addRow("Actual Free Physical Memory", CliManagerUtils.formatLongValue(actualFreePhysicalMemorySizeInBytes));
        output.addRow("Actual Memory Used", CliManagerUtils.formatLongValue(actualMemoryUsed));
        output.addRow("Free Physical Memory", CliManagerUtils.formatLongValue(freePhysicalMemorySizeInBytes));
        output.addRow("Free Swap Space", CliManagerUtils.formatLongValue(freeSwapSpaceSizeInBytes));
        output.addRow("Physical Memory Used", CliManagerUtils.formatDecimalValue(physicalMemoryUsedPerc) + "%");
        ConsoleOutput.newline();
        ConsoleOutput.print(output);
    }

    private void printOperatingSystemDetails(ApiResponse<OperatingSystemDetails> operatingSystemDetailsApiResponse) {
        OperatingSystemDetails osDetails = (OperatingSystemDetails)operatingSystemDetailsApiResponse.getData();
        String name = osDetails.getName();
        String id = osDetails.getId();
        String arch = osDetails.getArch();
        String vendor = osDetails.getVendor();
        String vendorCodeName = osDetails.getVendorCodeName();
        String vendorName = osDetails.getVendorName();
        String vendorVersion = osDetails.getVendorVersion();
        String version = osDetails.getVersion();
        Integer availableProcessors = osDetails.getAvailableProcessors();
        Long timeDelta = osDetails.getTimeDelta();
        Long totalPhysicalMemorySizeInBytes = osDetails.getTotalPhysicalMemorySizeInBytes();
        Long totalSwapSpaceSizeInBytes = osDetails.getTotalSwapSpaceSizeInBytes();
        Output output = new Output();
        output.addColumn(HEADER_OS_DETAILS);
        output.addRow("Name", name);
        output.addRow("ID", id);
        output.addRow("Arch.", arch);
        output.addRow("Vendor", vendor);
        output.addRow("Vendor Code Name", vendorCodeName);
        output.addRow("Vendor Name", vendorName);
        output.addRow("Vendor Version", vendorVersion);
        output.addRow("Version", version);
        output.addRow("Available Processors", String.valueOf(availableProcessors));
        output.addRow("Time Delta", CliManagerUtils.formatLongValue(timeDelta));
        output.addRow("Total Physical Memory", CliManagerUtils.formatLongValue(totalPhysicalMemorySizeInBytes));
        output.addRow("Total Swap Space", CliManagerUtils.formatLongValue(totalSwapSpaceSizeInBytes));
        ConsoleOutput.newline();
        ConsoleOutput.print(output);
    }
}

