/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.host;

import com.gigaspaces.internal.os.ProcessUtils;
import com.gigaspaces.logger.GSLogConfigLoader;
import com.gigaspaces.start.SystemBoot;
import com.gigaspaces.start.SystemInfo;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gigaspaces.cli.CliCommand;
import picocli.CommandLine;

@CommandLine.Command(name="kill-agent", header={"Kill the running Grid Service Agent (--help for options)"})
public class HostKillAgentCommand
extends CliCommand {
    @CommandLine.Option(names={"--all"}, description={"Kills all agents on current host"})
    boolean all;
    @CommandLine.Parameters(arity="0..*")
    int[] pids;
    protected static Logger LOGGER;
    private static final long PROCESS_KILL_TIMEOUT;

    public HostKillAgentCommand() {
        GSLogConfigLoader.getLoader((String)"cli");
        LOGGER = Logger.getLogger("com.gigaspaces.admin.cli");
    }

    protected void execute() throws Exception {
        Set<Integer> allRunningAgentsPids = this.getAllRunningAgents();
        boolean areAllSucceeded = true;
        if (this.all) {
            for (Integer pid : allRunningAgentsPids) {
                if (this.killAgent(pid)) continue;
                areAllSucceeded = false;
            }
        } else if (this.pids != null && this.pids.length != 0) {
            for (int pid : this.pids) {
                if (allRunningAgentsPids.contains(pid)) {
                    if (this.killAgent(pid)) continue;
                    areAllSucceeded = false;
                    continue;
                }
                System.err.println("Agent [" + pid + "] not found");
            }
        } else if (allRunningAgentsPids.isEmpty()) {
            System.out.println("No running agents found");
        } else if (allRunningAgentsPids.size() == 1) {
            if (!this.killAgent(allRunningAgentsPids.iterator().next())) {
                areAllSucceeded = false;
            }
        } else {
            System.err.println("Use the --all option to kill all agents or specify an agent process ID from: " + allRunningAgentsPids);
            System.exit(1);
        }
        if (!areAllSucceeded) {
            System.exit(1);
        }
    }

    private boolean killAgent(int pid) {
        boolean isKilled;
        block4: {
            System.out.println("Killing agent [" + pid + "] ...");
            isKilled = false;
            try {
                isKilled = ProcessUtils.kill((long)pid, (long)PROCESS_KILL_TIMEOUT);
                if (isKilled) {
                    System.out.println("Agent [" + pid + "] successfully killed");
                } else {
                    System.err.println("Failed to kill agent [" + pid + "]");
                }
            }
            catch (Exception e) {
                System.err.println("Failed to kill agent [" + pid + "] due " + e.toString());
                if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
        return isKilled;
    }

    private Set<Integer> getAllRunningAgents() {
        File workLocation = new File(SystemInfo.singleton().locations().work());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "workLocation=" + workLocation + ", exists:" + workLocation.exists());
        }
        File gsaDir = new File(workLocation, "gsa");
        HashSet<Integer> runningAgents = new HashSet<Integer>();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "workLocation=" + gsaDir + ", exists:" + gsaDir.exists());
        }
        if (gsaDir.exists()) {
            File[] files;
            for (File file : files = gsaDir.listFiles()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Checking file [" + file.getName() + "]");
                }
                boolean isGsaOut = SystemBoot.isGsaOut((File)file);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "After Checking file [" + file.getName() + "], isGsaOut=" + isGsaOut);
                }
                if (isGsaOut) continue;
                try {
                    runningAgents.add(HostKillAgentCommand.getPidFromAgentFileName(file.getName()));
                }
                catch (Exception fne) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                    LOGGER.log(Level.SEVERE, fne.toString(), fne);
                }
            }
        } else {
            System.out.println("No agents to kill");
        }
        return runningAgents;
    }

    private static Integer getPidFromAgentFileName(String s) {
        int endIndex = (s = s.substring("gsa-".length())).indexOf(126);
        if (endIndex != -1) {
            s = s.substring(0, endIndex);
            return Integer.parseInt(s);
        }
        throw new IllegalStateException("PID of agent '" + s + "' is missing");
    }

    static {
        PROCESS_KILL_TIMEOUT = Long.getLong("com.gs.service-grid.process-kill-timeout", 30000L);
    }
}

