/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.host;

import com.gigaspaces.cli.commands.GigaSpacesRestCommand;
import com.gigaspaces.cli.commands.output.ConsoleOutput;
import com.gigaspaces.cli.commands.output.Output;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.HostsApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.Host;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="list", header={"List all hosts (and the number of containers per host)"})
public class HostListCommand
extends GigaSpacesRestCommand {
    private static final String[] headersList = new String[]{"Host Name", "Host Address", "Containers Count"};

    protected void execute() throws Exception {
        try {
            int totalContainers;
            Output output;
            List responseData;
            ApiResponse response = new HostsApi().hostsGetWithHttpInfo();
            if (response.getStatusCode() == 200) {
                responseData = (List)response.getData();
                output = new Output();
                output.addColumns(headersList);
                totalContainers = 0;
                for (Host host : responseData) {
                    int numOfContainers = host.getContainers().size();
                    totalContainers += numOfContainers;
                    output.addRow(host.getName(), host.getAddress(), String.valueOf(numOfContainers));
                }
            } else {
                throw CliManagerUtils.getHttpFailureException(response);
            }
            ConsoleOutput.newline();
            ConsoleOutput.println(output);
            Output sumOutput = new Output();
            sumOutput.addColumn("SUMMARY");
            sumOutput.addRow("Hosts:", String.valueOf(responseData.size())).addRow("Containers:", String.valueOf(totalContainers));
            ConsoleOutput.newline();
            ConsoleOutput.println(sumOutput);
        }
        catch (ApiException e) {
            throw CliManagerUtils.createThrownException((Exception)((Object)e));
        }
    }
}

