/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.host;

import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.start.manager.XapManagerClusterInfo;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.gigaspaces.cli.CliCommand;
import org.gigaspaces.cli.CliCommandException;
import org.gigaspaces.cli.commands.XapMainCommand;
import org.gigaspaces.cli.commands.utils.XapCliUtils;
import picocli.CommandLine;

@CommandLine.Command(name="run-agent", header={"Run a Grid Service Agent on the current host (--help for options)"})
public class HostRunAgentCommand
extends CliCommand {
    private final String MANAGER_OPTION = "--manager";
    private final String MANAGER_LOCAL_OPTION = "--manager-local";
    private final String WEBUI_OPTION = "--webui";
    @CommandLine.Option(names={"--auto"}, description={"Automatically resolve which service to run on the current host"})
    protected boolean auto;
    @CommandLine.Option(names={"--manager"}, description={"Run one instance of the Manager (from the cluster of Managers)"})
    protected Boolean manager;
    @CommandLine.Option(names={"--webui"}, description={"Start the Web Management Console"})
    Boolean webUi;
    @CommandLine.Option(names={"--containers", "--gsc"}, description={"Specify the number of containers to start (default is 0)"})
    int gscs;
    @CommandLine.Option(names={"--custom"}, description={"Specify which custom service to run by the agent (for example: --custom=global.lus=1)"})
    Map<String, Integer> customComponents;

    protected void execute() throws Exception {
        ProcessBuilder processBuilder = this.createProcessBuilder();
        XapCliUtils.executeProcess((ProcessBuilder)processBuilder);
    }

    public ProcessBuilder createProcessBuilder() throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        LinkedHashSet<String> command = new LinkedHashSet<String>();
        String scriptHome = SystemInfo.singleton().locations().bin();
        String suffix = XapMainCommand.isXapNet() ? ".exe" : (SystemInfo.singleton().os().isWindows() ? ".bat" : ".sh");
        command.add(scriptHome + File.separator + "gs-agent" + suffix);
        this.appendOptions(command);
        if (command.size() == 1) {
            command.add("-z");
        }
        processBuilder.command().addAll(command);
        processBuilder.directory(new File(scriptHome));
        processBuilder.inheritIO();
        processBuilder.environment().put("XAP_GSA_SKIP_DEPRECATED", "true");
        return processBuilder;
    }

    protected boolean isTrue(Boolean aBoolean) {
        return aBoolean != null && aBoolean != false;
    }

    protected void appendOptions(Collection<String> command) throws CliCommandException {
        XapManagerClusterInfo managerClusterInfo;
        if (this.auto) {
            if (this.isTrue(this.manager)) {
                throw CliCommandException.userError((String)"Illegal combination: choose either '--manager' for a cluster of Managers or '--auto' for a local Manager");
            }
            XapManagerClusterInfo managerClusterInfo2 = SystemInfo.singleton().getManagerClusterInfo();
            boolean isManager = managerClusterInfo2.getServers().length == 0 ? true : managerClusterInfo2.getCurrServer() != null;
            this.addAutoComponents(command, isManager);
        } else if (this.manager != null && this.manager.booleanValue() && (managerClusterInfo = SystemInfo.singleton().getManagerClusterInfo()).getServers().length == 0) {
            System.err.println("XAP Manager configuration is missing.\n- To run a standalone Manager on this machine, use --auto\n- To configure a cluster of Managers on 1 or 3 machines (including this one), edit the setenv-overrides script (located in " + SystemInfo.singleton().locations().bin() + ") and set the " + "XAP_MANAGER_SERVERS" + " environment variable to list the designated Manager servers. \n");
            System.exit(1);
        }
        this.processOption(this.manager, "--manager", command);
        this.processOption(this.webUi, "--webui", command);
        this.processOption(this.gscs, "--gsc", command);
        if (this.customComponents != null) {
            for (Map.Entry<String, Integer> entry : this.customComponents.entrySet()) {
                command.add("--" + entry.getKey() + "=" + entry.getValue());
            }
        }
    }

    protected void addAutoComponents(Collection<String> command, boolean isManager) {
        if (isManager) {
            XapManagerClusterInfo managerClusterInfo = SystemInfo.singleton().getManagerClusterInfo();
            if (managerClusterInfo.getServers().length == 0) {
                command.add("--manager-local");
            } else {
                command.add("--manager");
            }
            command.add("--webui");
        }
    }

    protected void processOption(Boolean arg, String option, Collection<String> options) {
        if (arg != null) {
            if (arg.booleanValue()) {
                options.add(option);
            } else {
                options.remove(option);
            }
        }
    }

    private void processOption(int arg, String option, Collection<String> options) {
        if (arg != 0) {
            options.add(option + "=" + arg);
        }
    }

    public void setAuto(boolean auto) {
        this.auto = auto;
    }

    public void setGscs(int gscs) {
        this.gscs = gscs;
    }
}

