/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.output;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class Output {
    public static String EMPTY = "";
    private List<String> columns = new LinkedList<String>();
    private List<Integer> columnWidth = new LinkedList<Integer>();
    private List<List<String>> rows = new LinkedList<List<String>>();
    private boolean upperCaseCols = true;

    public Output upperCaseColumns(boolean upperCaseCols) {
        this.upperCaseCols = upperCaseCols;
        return this;
    }

    public Output addColumn(String column) {
        int index = this.columns.size();
        this.columns.add(this.upperCaseCols ? column.toUpperCase() : column);
        this.updateColumnWidth(index, column.length());
        return this;
    }

    public Output addColumns(String ... columns) {
        for (String column : columns) {
            this.addColumn(column);
        }
        return this;
    }

    public Output addColumns(Collection<String> columns) {
        for (String column : columns) {
            this.addColumn(column);
        }
        return this;
    }

    private void updateColumnWidth(int index, int length) {
        if (index < this.columnWidth.size()) {
            this.columnWidth.set(index, Math.max(this.columnWidth.get(index), length));
        } else {
            this.columnWidth.add(length);
        }
    }

    public Output addRow(List<String> row) {
        this.rows.add(row);
        for (int i = 0; i < row.size(); ++i) {
            this.updateColumnWidth(i, row.get(i).length());
        }
        return this;
    }

    public Output addRow(String ... row) {
        return this.addRow(Arrays.asList(row));
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<List<String>> getRows() {
        return this.rows;
    }

    public List<Integer> getColumnWidth() {
        return this.columnWidth;
    }
}

