/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.output;

import com.gigaspaces.cli.commands.output.Output;
import java.util.List;

public class PlainTextOutput {
    private static final String TABS = "    ";
    private static final String NEWLINE = System.lineSeparator();
    private static final char SPACE = ' ';
    private final Output output;

    public PlainTextOutput(Output output) {
        this.output = output;
    }

    public String getOutput() {
        StringBuilder sb = new StringBuilder();
        List<String> columns = this.output.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            String column = columns.get(i);
            sb.append(column);
            this.addPadding(sb, i, column.length());
            sb.append(TABS);
        }
        if (!columns.isEmpty()) {
            sb.append(NEWLINE);
        }
        List<List<String>> rows = this.output.getRows();
        for (List<String> row : rows) {
            for (int i = 0; i < row.size(); ++i) {
                String data = row.get(i);
                sb.append(data);
                this.addPadding(sb, i, data.length());
                sb.append(TABS);
            }
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    private void addPadding(StringBuilder sb, int index, int length) {
        List<Integer> columnWidth = this.output.getColumnWidth();
        int padding = columnWidth.get(index) - length;
        for (int p = 0; p < padding; ++p) {
            sb.append(' ');
        }
    }
}

