/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.pu;

import com.gigaspaces.cli.commands.AbstractAsynchronousCommand;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.ProcessingUnitsApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.Request;
import picocli.CommandLine;

@CommandLine.Command(name="decrement", header={"Remove one instance from the specified Processing Unit"})
public class ProcessingUnitDecrementCommand
extends AbstractAsynchronousCommand {
    @CommandLine.Parameters(paramLabel="<instance ID>", index="0", description={"The ID of the Processing Unit instance to decrement"})
    String instanceId;

    @Override
    protected void printSuccessfulResultMessage(Request responseData) {
        System.out.println("\nProcessing Unit instance [" + this.instanceId + "] was successfully terminated at " + responseData.getCompletedAt());
    }

    @Override
    protected ApiResponse<String> runAsyncRequest() throws ApiException {
        String name = CliManagerUtils.retrievePuName(this.instanceId);
        ApiResponse response = new ProcessingUnitsApi().pusIdInstancesInstanceIdDeleteWithHttpInfo(name, this.instanceId);
        return response;
    }
}

