/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.pu;

import com.gigaspaces.cli.commands.AbstractAsynchronousCommand;
import com.gigaspaces.cli.commands.pu.ProcessingUnitUploadResourceCommand;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.ProcessingUnitsApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.ProcessingUnitRequest;
import com.gigaspaces.rest.client.java.model.ProcessingUnitSLA;
import com.gigaspaces.rest.client.java.model.ProcessingUnitTopology;
import com.gigaspaces.rest.client.java.model.Request;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.gigaspaces.cli.CliCommandException;
import picocli.CommandLine;

@CommandLine.Command(name="deploy", header={"Define a Processing Unit for deployment on the Service Grid"})
public class ProcessingUnitDeployCommand
extends AbstractAsynchronousCommand {
    @CommandLine.Parameters(index="0", description={"Name of Processing Unit to deploy"})
    String name;
    @CommandLine.Parameters(index="1", description={"Path to Processing Unit archive file"})
    File file;
    private String fileName;
    @CommandLine.Option(names={"--schema"}, description={"Define the cluster schema (for example: partitioned)"})
    Schema schema;
    @CommandLine.Option(names={"--instances"}, description={"Specify the number of stateless Processing Unit instances"})
    int instances = -1;
    @CommandLine.Option(names={"--partitions"}, description={"Specify the number of partitions"})
    int partitions = -1;
    @CommandLine.Option(names={"--backups"}, description={"Specify the number of backups per partition"})
    int backups = -1;
    @CommandLine.Option(names={"--requires-isolation"}, description={"Provision instances in a dedicated container"})
    boolean requiresIsolation;
    @CommandLine.Option(names={"--zones"}, description={"Specify the zone that will host this Processing Unit"})
    String[] zones;
    @CommandLine.Option(names={"--primary-zones"}, description={"Specify the preferred zones to host primary instances (applies only when Deterministic Deployment is configured)"})
    String[] primaryZones;
    @CommandLine.Option(names={"--max-instances-per-vm"}, description={"Define the maximum number of instances allowed in a container"})
    int maxInstancesPerVM;
    @CommandLine.Option(names={"--max-instances-per-machine"}, description={"Define the maximum number of instances allowed on the same host"})
    int maxInstancesPerMachine;
    @CommandLine.Option(names={"--properties"}, description={"Location of context level properties file"})
    String propertiesFilePath;
    @CommandLine.Option(names={"--property"}, description={"Context properties (for example: --property=k1=v1 --property=k2=v2)"})
    Map<String, String> contextProperties;
    private Set<String> deployedInstances = new HashSet<String>();

    @Override
    protected void execute() throws Exception {
        this.validateParameters();
        this.validateOptions();
        this.validateAndLoadPropertiesFile();
        this.fileName = ProcessingUnitDeployCommand.upload(this.file);
        super.execute();
    }

    private static String upload(File file) throws Exception {
        File uploadFile = file.isDirectory() ? ProcessingUnitUploadResourceCommand.createTempZip(file) : file;
        try {
            ProcessingUnitsApi processingUnitsApi = new ProcessingUnitsApi();
            ApiResponse uploadResourceResponse = processingUnitsApi.pusResourcesPutWithHttpInfo(uploadFile);
            if (uploadResourceResponse.getStatusCode() == 201) {
                String result = uploadFile.getName();
                System.out.println("\n[" + result + "] successfully uploaded");
                String string = result;
                return string;
            }
            try {
                throw CliManagerUtils.getHttpFailureException(uploadResourceResponse);
            }
            catch (ApiException e) {
                throw CliManagerUtils.createThrownException((Exception)((Object)e));
            }
        }
        finally {
            if (file != uploadFile) {
                ProcessingUnitUploadResourceCommand.deleteTempFile(uploadFile);
            }
        }
    }

    private void validateParameters() throws CliCommandException {
        if (this.file != null && !this.file.exists()) {
            throw CliCommandException.userError((String)("Invalid parameter: path to Processing Unit archive file points to non existing file: " + this.file.getPath()));
        }
    }

    private void validateOptions() throws CliCommandException {
        if (this.schema == null && this.partitions > 0) {
            this.schema = Schema.partitioned;
        }
        if (Schema.partitioned.equals((Object)this.schema)) {
            if (this.instances != -1) {
                throw CliCommandException.userError((String)"Illegal argument: '--instances' is not applicable for 'partitioned' schema");
            }
        } else {
            if (this.backups != -1) {
                throw CliCommandException.userError((String)"Illegal argument: '--backups' is only applicable for 'partitioned' schema");
            }
            if (this.partitions != -1) {
                throw CliCommandException.userError((String)"Illegal argument: '--partitions' is only applicable for 'partitioned' schema");
            }
        }
    }

    private void validateAndLoadPropertiesFile() throws CliCommandException {
        if (this.propertiesFilePath != null) {
            File propertiesFile = new File(this.propertiesFilePath);
            if (!propertiesFile.exists()) {
                throw CliCommandException.userError((String)("Invalid argument: '--properties' points to non existing file: " + this.propertiesFilePath));
            }
            this.loadPropertiesFileIfProvided(propertiesFile);
        }
    }

    private void loadPropertiesFileIfProvided(File propertiesFile) throws CliCommandException {
        if (propertiesFile != null) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(propertiesFile));
            }
            catch (IOException ioException) {
                throw new CliCommandException(ioException.getMessage());
            }
            if (!properties.isEmpty()) {
                if (this.contextProperties == null) {
                    this.contextProperties = new HashMap<String, String>();
                }
                for (String name : properties.stringPropertyNames()) {
                    if (this.contextProperties.containsKey(name)) continue;
                    this.contextProperties.put(name, properties.getProperty(name));
                }
            }
        }
    }

    private ProcessingUnitRequest createProcessingUnitRequest() {
        ProcessingUnitRequest processingUnitRequest = new ProcessingUnitRequest();
        processingUnitRequest.setContextProperties(this.contextProperties);
        processingUnitRequest.setName(this.name);
        processingUnitRequest.setResource(this.fileName);
        processingUnitRequest.setTopology(this.createProcessingUnitTopology());
        processingUnitRequest.setSla(this.createSla());
        return processingUnitRequest;
    }

    private ProcessingUnitSLA createSla() {
        ProcessingUnitSLA processingUnitSLA = new ProcessingUnitSLA();
        if (this.maxInstancesPerMachine > 0) {
            processingUnitSLA.setMaxInstancesPerMachine(Integer.valueOf(this.maxInstancesPerMachine));
        }
        if (this.maxInstancesPerVM > 0) {
            processingUnitSLA.setMaxInstancesPerVM(Integer.valueOf(this.maxInstancesPerVM));
        }
        if (this.zones != null) {
            processingUnitSLA.setZones(Arrays.asList(this.zones));
        }
        if (this.primaryZones != null) {
            processingUnitSLA.setPrimaryZones(Arrays.asList(this.primaryZones));
        }
        processingUnitSLA.setRequiresIsolation(Boolean.valueOf(this.requiresIsolation));
        return processingUnitSLA;
    }

    private ProcessingUnitTopology createProcessingUnitTopology() {
        ProcessingUnitTopology processingUnitTopology = new ProcessingUnitTopology();
        if (this.backups >= 0) {
            processingUnitTopology.setBackupsPerPartition(Integer.valueOf(this.backups));
        }
        if (this.instances >= 0) {
            processingUnitTopology.setInstances(Integer.valueOf(this.instances));
        }
        if (this.partitions >= 0) {
            processingUnitTopology.setPartitions(Integer.valueOf(this.partitions));
            processingUnitTopology.setSchema(ProcessingUnitTopology.SchemaEnum.PARTITIONED);
        }
        if (this.schema != null) {
            processingUnitTopology.setSchema(ProcessingUnitTopology.SchemaEnum.fromValue((String)this.schema.name()));
        }
        return processingUnitTopology;
    }

    @Override
    protected boolean handleWaiting(Request request, ApiResponse<Request> getIdResponse, boolean forcePrintProgress) throws CliCommandException {
        if (System.currentTimeMillis() - this.startWaitingSuccessfulRequestTime > (long)(this.getWaitingTimeout() * 1000)) {
            return this.handleTimeout(request);
        }
        if (this.sleepCount % 5 == 0 || forcePrintProgress) {
            Request data = (Request)getIdResponse.getData();
            Map progressResult = data.getResult();
            if (progressResult != null) {
                Set resultEntries = progressResult.entrySet();
                boolean isFirst = false;
                for (Map.Entry entry : resultEntries) {
                    String value = (String)entry.getValue();
                    String key = (String)entry.getKey();
                    if (value == null || !value.equals("SUCCESS") || this.deployedInstances.contains(key)) continue;
                    if (!isFirst) {
                        System.out.println("");
                        isFirst = true;
                    }
                    System.out.println("Instance [" + key + "] successfully deployed");
                    this.deployedInstances.add(key);
                }
            }
            if (!forcePrintProgress) {
                System.out.print("\u00b7");
            }
        }
        return false;
    }

    @Override
    protected void printSuccessfulResultMessage(Request responseData) {
        String statusUrl = responseData.getStatusUrl();
        System.out.println("\nProcessing Unit [" + statusUrl.substring(statusUrl.lastIndexOf(47) + 1) + "] was successfully deployed at " + responseData.getCompletedAt());
    }

    @Override
    protected ApiResponse<String> runAsyncRequest() throws ApiException {
        ProcessingUnitsApi processingUnitsApi = new ProcessingUnitsApi();
        ProcessingUnitRequest processingUnitRequest = this.createProcessingUnitRequest();
        ApiResponse response = processingUnitsApi.pusPostWithHttpInfo(processingUnitRequest);
        return response;
    }

    public static enum Schema {
        partitioned,
        sync_replicated,
        async_replicated;

    }
}

