/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.pu;

import com.gigaspaces.cli.commands.AbstractAsynchronousCommand;
import com.gigaspaces.rest.client.java.api.ProcessingUnitsApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.Request;
import picocli.CommandLine;

@CommandLine.Command(name="increment", header={"Add one instance to the specified Processing Unit"})
public class ProcessingUnitIncrementCommand
extends AbstractAsynchronousCommand {
    @CommandLine.Parameters(index="0", description={"Name of the stateless Processing Unit to increment"})
    String name;

    @Override
    protected void printSuccessfulResultMessage(Request responseData) {
        String statusUrl = responseData.getStatusUrl();
        System.out.println("\nProcessing Unit [" + this.name + "] was successfully increased by adding [" + statusUrl.substring(statusUrl.lastIndexOf(47) + 1) + "] instance at " + responseData.getCompletedAt());
    }

    @Override
    protected ApiResponse<String> runAsyncRequest() throws ApiException {
        ApiResponse response = new ProcessingUnitsApi().pusIdInstancesPostWithHttpInfo(this.name);
        return response;
    }
}

