/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.pu;

import com.gigaspaces.cli.commands.GigaSpacesRestCommand;
import com.gigaspaces.cli.commands.output.ConsoleOutput;
import com.gigaspaces.cli.commands.output.Output;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.ProcessingUnitsApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.ProcessingUnit;
import com.gigaspaces.rest.client.java.model.ProcessingUnitSLA;
import com.gigaspaces.rest.client.java.model.ProcessingUnitTopology;
import com.gigaspaces.rest.client.java.model.QuiesceDetails;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="info", header={"Show information for the specified Processing Unit"})
public class ProcessingUnitInfoCommand
extends GigaSpacesRestCommand {
    @CommandLine.Parameters(index="0", description={"Processing Unit name"})
    String name;
    public static final String HEADER_PU_DETAILS = "PROCESSING UNIT DETAILS";

    protected void execute() throws Exception {
        try {
            ProcessingUnitsApi processingUnitsApi = new ProcessingUnitsApi();
            ApiResponse response = processingUnitsApi.pusIdGetWithHttpInfo(this.name);
            if (response.getStatusCode() != 200) {
                throw CliManagerUtils.getHttpFailureException(response);
            }
            this.printProcessingUnitDetails((ApiResponse<ProcessingUnit>)response);
        }
        catch (ApiException e) {
            throw CliManagerUtils.createThrownException((Exception)((Object)e));
        }
    }

    private void printProcessingUnitDetails(ApiResponse<ProcessingUnit> response) {
        ProcessingUnit data = (ProcessingUnit)response.getData();
        String name = data.getName();
        String resource = data.getResource();
        ProcessingUnit.ProcessingUnitTypeEnum processingUnitType = data.getProcessingUnitType();
        List spaces = data.getSpaces();
        ProcessingUnit.StatusEnum status = data.getStatus();
        Boolean scalable = data.isScalable();
        QuiesceDetails quiesceDetails = data.getQuiesceDetails();
        ProcessingUnitSLA sla = data.getSla();
        String zonesPresentation = CliManagerUtils.getObjectsTextPresentation(sla.getZones());
        ProcessingUnitTopology topology = data.getTopology();
        List instancesIds = data.getInstances();
        Output output = new Output();
        output.addColumn(HEADER_PU_DETAILS);
        output.addRow("Name", name);
        output.addRow("Resource", resource);
        output.addRow("Type", String.valueOf(processingUnitType));
        if (spaces != null && !spaces.isEmpty()) {
            output.addRow("Space", (String)spaces.get(0));
        }
        output.addRow("Status", String.valueOf(status));
        output.addRow("Quiesce Details", CliManagerUtils.createQuiesceDetailsPresentation(quiesceDetails));
        output.addRow("Scalable", String.valueOf(scalable));
        output.addRow("Zones", zonesPresentation);
        output.addRow("Requires Isolation", String.valueOf(sla.isRequiresIsolation()));
        output.addRow("Max. Instances Per VM", String.valueOf(sla.getMaxInstancesPerVM()));
        output.addRow("Max. Instances Per Machine", String.valueOf(sla.getMaxInstancesPerMachine()));
        output.addRow("Topology", CliManagerUtils.createTopologyPresentation(topology));
        output.addRow("Planned Instances", String.valueOf(CliManagerUtils.getPlannedInstances(topology)));
        output.addRow("Actual Instances", String.valueOf(instancesIds.size()));
        output.addRow("Instances", instancesIds.isEmpty() ? Output.EMPTY : (String)instancesIds.get(0));
        int instancesCount = instancesIds.size();
        for (int instanceIndex = 1; instanceIndex < instancesCount; ++instanceIndex) {
            String instanceId = (String)instancesIds.get(instanceIndex);
            output.addRow(Output.EMPTY, instanceId);
        }
        ConsoleOutput.newline();
        ConsoleOutput.print(output);
    }
}

