/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.pu;

import com.gigaspaces.cli.commands.GigaSpacesRestCommand;
import com.gigaspaces.cli.commands.output.ConsoleOutput;
import com.gigaspaces.cli.commands.output.Output;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.ProcessingUnitsApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.ProcessingUnitInstance;
import picocli.CommandLine;

@CommandLine.Command(name="info-instance", header={"Show the specified Processing Unit instance information"})
public class ProcessingUnitInfoInstanceCommand
extends GigaSpacesRestCommand {
    @CommandLine.Parameters(paramLabel="<instance ID>", index="0", description={"ID of Processing Unit instance"})
    String instanceId;
    public static final String HEADER_PU_INSTANCE_DETAILS = "PROCESSING UNIT INSTANCE DETAILS";

    protected void execute() throws Exception {
        try {
            ProcessingUnitsApi processingUnitsApi = new ProcessingUnitsApi();
            String puName = CliManagerUtils.retrievePuName(this.instanceId);
            ApiResponse response = processingUnitsApi.pusIdInstancesInstanceIdGetWithHttpInfo(puName, this.instanceId);
            if (response.getStatusCode() != 200) {
                throw CliManagerUtils.getHttpFailureException(response);
            }
            this.printProcessingUnitInstanceDetails((ApiResponse<ProcessingUnitInstance>)response);
        }
        catch (ApiException e) {
            throw CliManagerUtils.createThrownException((Exception)((Object)e));
        }
    }

    private void printProcessingUnitInstanceDetails(ApiResponse<ProcessingUnitInstance> response) {
        ProcessingUnitInstance data = (ProcessingUnitInstance)response.getData();
        String id = data.getId();
        String processingUnitName = data.getProcessingUnitName();
        Integer partitionId = data.getPartitionId();
        String hostId = data.getHostId();
        String containerId = data.getContainerId();
        Integer backupId = data.getBackupId();
        Output output = new Output();
        output.addColumn(HEADER_PU_INSTANCE_DETAILS);
        output.addRow("ID", id);
        output.addRow("PU Name", processingUnitName);
        output.addRow("Partition ID", String.valueOf(partitionId));
        output.addRow("Container ID", containerId);
        output.addRow("Host ID", hostId);
        output.addRow("Backup ID", String.valueOf(backupId));
        ConsoleOutput.newline();
        ConsoleOutput.print(output);
    }
}

