/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.pu;

import com.gigaspaces.cli.commands.GigaSpacesRestCommand;
import com.gigaspaces.cli.commands.output.ConsoleOutput;
import com.gigaspaces.cli.commands.output.Output;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.ProcessingUnitsApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.ProcessingUnit;
import com.gigaspaces.rest.client.java.model.ProcessingUnitTopology;
import com.gigaspaces.rest.client.java.model.QuiesceDetails;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="list", header={"List the deployed Processing Units"})
public class ProcessingUnitListCommand
extends GigaSpacesRestCommand {
    private static final String[] headersList = new String[]{"Name", "Type", "Space", "Topology", "Status", "Resource", "Quiesced", "Instances Count"};

    protected void execute() throws Exception {
        try {
            int totalInstances;
            Output output;
            List responseData;
            ApiResponse response = new ProcessingUnitsApi().pusGetWithHttpInfo();
            if (response.getStatusCode() == 200) {
                responseData = (List)response.getData();
                output = new Output();
                output.addColumns(headersList);
                totalInstances = 0;
                for (ProcessingUnit processingUnit : responseData) {
                    String name = processingUnit.getName();
                    ProcessingUnit.ProcessingUnitTypeEnum processingUnitType = processingUnit.getProcessingUnitType();
                    List spaces = processingUnit.getSpaces();
                    ProcessingUnit.StatusEnum status = processingUnit.getStatus();
                    ProcessingUnitTopology topology = processingUnit.getTopology();
                    String resource = processingUnit.getResource();
                    List instances = processingUnit.getInstances();
                    totalInstances += instances.size();
                    QuiesceDetails quiesceDetails = processingUnit.getQuiesceDetails();
                    output.addRow(name, processingUnitType.name(), spaces != null && !spaces.isEmpty() ? (String)spaces.get(0) : Output.EMPTY, CliManagerUtils.createTopologyPresentation(topology), status.name(), resource, quiesceDetails.isQuiesced().toString(), String.valueOf(instances.size()));
                }
            } else {
                throw CliManagerUtils.getHttpFailureException(response);
            }
            ConsoleOutput.newline();
            ConsoleOutput.println(output);
            Output sumOutput = new Output();
            sumOutput.addColumn("SUMMARY");
            sumOutput.addRow("Processing Units:", String.valueOf(responseData.size())).addRow("Instances:", String.valueOf(totalInstances));
            ConsoleOutput.newline();
            ConsoleOutput.println(sumOutput);
        }
        catch (ApiException e) {
            throw CliManagerUtils.createThrownException((Exception)((Object)e));
        }
    }
}

