/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.pu;

import com.gigaspaces.cli.commands.GigaSpacesRestCommand;
import com.gigaspaces.cli.commands.output.ConsoleOutput;
import com.gigaspaces.cli.commands.output.Output;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.ProcessingUnitsApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.ProcessingUnitInstance;
import java.util.HashSet;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="list-instances", header={"Lists the instances of the specified Processing Unit"})
public class ProcessingUnitListInstancesCommand
extends GigaSpacesRestCommand {
    @CommandLine.Parameters(index="0", description={"Name of Processing Unit to list instances"})
    String name;
    private static final String[] headersList = new String[]{"Instance ID", "Host ID", "Container ID"};

    protected void execute() throws Exception {
        try {
            HashSet<String> uniqueContainers;
            HashSet<String> uniqueHosts;
            Output output;
            List responseData;
            ApiResponse response = new ProcessingUnitsApi().pusIdInstancesGetWithHttpInfo(this.name);
            if (response.getStatusCode() == 200) {
                responseData = (List)response.getData();
                output = new Output();
                output.addColumns(headersList);
                uniqueHosts = new HashSet<String>();
                uniqueContainers = new HashSet<String>();
                for (ProcessingUnitInstance processingUnitInstance : responseData) {
                    output.addRow(processingUnitInstance.getId(), processingUnitInstance.getHostId(), processingUnitInstance.getContainerId());
                    uniqueHosts.add(processingUnitInstance.getHostId());
                    uniqueContainers.add(processingUnitInstance.getContainerId());
                }
            } else {
                throw CliManagerUtils.getHttpFailureException(response);
            }
            ConsoleOutput.newline();
            ConsoleOutput.println(output);
            Output sumOutput = new Output();
            sumOutput.addColumn("SUMMARY");
            sumOutput.addRow("Instances:", String.valueOf(responseData.size())).addRow("Hosts:", String.valueOf(uniqueHosts.size())).addRow("Containers:", String.valueOf(uniqueContainers.size()));
            ConsoleOutput.newline();
            ConsoleOutput.println(sumOutput);
        }
        catch (ApiException e) {
            throw CliManagerUtils.createThrownException((Exception)((Object)e));
        }
    }
}

