/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.pu;

import com.gigaspaces.cli.commands.AbstractAsynchronousCommand;
import com.gigaspaces.rest.client.java.api.ProcessingUnitsApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.Request;
import java.util.Map;
import picocli.CommandLine;

@CommandLine.Command(name="quiesce", header={"Disable a running Processing Unit for maintenance"})
public class ProcessingUnitQuiesceCommand
extends AbstractAsynchronousCommand {
    @CommandLine.Parameters(index="0", description={"Name of the running Processing Unit to disable"})
    String name;
    @CommandLine.Option(names={"--description"}, description={"Reason for disabling the Processing Unit (for auditing purposes)"})
    String description;

    @Override
    protected void printSuccessfulResultMessage(Request responseData) {
        Map result = responseData.getResult();
        System.out.println("\nProcessing Unit [" + this.name + "] was successfully quiesced at " + responseData.getCompletedAt() + " with token [" + (String)result.get("token") + "]");
    }

    @Override
    protected ApiResponse<String> runAsyncRequest() throws ApiException {
        ApiResponse response = new ProcessingUnitsApi().pusIdQuiescePostWithHttpInfo(this.name, this.description);
        return response;
    }
}

