/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.pu;

import com.gigaspaces.cli.commands.AbstractAsynchronousCommand;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.ProcessingUnitsApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.Request;
import picocli.CommandLine;

@CommandLine.Command(name="relocate", header={"Move a Processing Unit instance to a different container"})
public class ProcessingUnitRelocateCommand
extends AbstractAsynchronousCommand {
    @CommandLine.Parameters(paramLabel="<instance ID>", index="0", description={"The ID of the Processing Unit instance to relocate"})
    String instanceId;
    @CommandLine.Parameters(paramLabel="<container ID>", index="1", arity="0..1", description={"The ID of the container to relocate to"})
    String targetContainerId;

    @Override
    protected void printSuccessfulResultMessage(Request responseData) {
        System.out.println("\nProcessing Unit instance [" + this.instanceId + "] was successfully relocated" + (this.targetContainerId == null ? "" : " to [ " + this.targetContainerId + "]"));
    }

    @Override
    protected ApiResponse<String> runAsyncRequest() throws ApiException {
        String puName = CliManagerUtils.retrievePuName(this.instanceId);
        ApiResponse response = new ProcessingUnitsApi().pusIdInstancesInstanceIdRelocatePostWithHttpInfo(puName, this.instanceId, this.targetContainerId);
        return response;
    }
}

