/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.pu;

import com.gigaspaces.cli.commands.AbstractAsynchronousCommand;
import com.gigaspaces.rest.client.java.api.ProcessingUnitsApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.Request;
import picocli.CommandLine;

@CommandLine.Command(name="undeploy", header={"Remove the specified Processing Unit from the Service Grid"})
public class ProcessingUnitUndeployCommand
extends AbstractAsynchronousCommand {
    @CommandLine.Parameters(index="0", description={"Name of Processing Unit to remove from the Service Grid"})
    String name;
    @CommandLine.Option(names={"--keep-file"}, description={"Do not delete the Processing Unit file (keep for future deployment)"})
    boolean keepFile = false;

    @Override
    protected void printSuccessfulResultMessage(Request responseData) {
        String statusUrl = responseData.getStatusUrl();
        System.out.println("\nProcessing Unit [" + statusUrl.substring(statusUrl.lastIndexOf(47) + 1) + "] was successfully undeployed at " + responseData.getCompletedAt());
    }

    @Override
    protected ApiResponse<String> runAsyncRequest() throws ApiException {
        ApiResponse response = new ProcessingUnitsApi().pusIdDeleteWithHttpInfo(this.name, Boolean.valueOf(this.keepFile));
        return response;
    }
}

