/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.pu;

import com.gigaspaces.cli.commands.GigaSpacesRestCommand;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.ProcessingUnitsApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.start.SystemInfo;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import org.gigaspaces.cli.CliCommandException;
import org.jini.rio.boot.PUZipUtils;
import picocli.CommandLine;

@CommandLine.Command(name="upload", header={"Upload a Processing Unit resource (Docker/Kubernetes users: this command does not provide high availability)"})
public class ProcessingUnitUploadResourceCommand
extends GigaSpacesRestCommand {
    @CommandLine.Parameters(index="0", description={"Path to resource file"})
    File file;
    @CommandLine.Option(names={"--url-only"}, description={"Print only the URL of the resource"})
    boolean urlOnly;

    protected void execute() throws Exception {
        this.validateFileParameter();
        String fileURL = ProcessingUnitUploadResourceCommand.upload(this.file);
        if (this.urlOnly) {
            System.out.println(fileURL);
        } else {
            System.out.println();
            System.out.println(MessageFormat.format("[{0}] successfully uploaded", this.file.getName()));
            System.out.println("Resource URL: " + fileURL);
            System.out.println();
            System.out.println("* Docker/Kubernetes users: this command does not provide high availability, and should not be used in production");
        }
    }

    private void validateFileParameter() throws CliCommandException {
        if (this.file == null) {
            throw CliCommandException.userError((String)"No path to resource file provided");
        }
        if (!this.file.exists()) {
            throw CliCommandException.userError((String)("Invalid parameter: path to Processing Unit archive file points to non existing file: " + this.file.getPath()));
        }
    }

    private static String upload(File file) throws Exception {
        File uploadFile = file.isDirectory() ? ProcessingUnitUploadResourceCommand.createTempZip(file) : file;
        try {
            ProcessingUnitsApi processingUnitsApi = new ProcessingUnitsApi();
            ApiResponse uploadResourceResponse = processingUnitsApi.pusResourcesPutWithHttpInfo(uploadFile);
            if (uploadResourceResponse.getStatusCode() == 201) {
                String string = (String)uploadResourceResponse.getData();
                return string;
            }
            try {
                throw CliManagerUtils.getHttpFailureException(uploadResourceResponse);
            }
            catch (ApiException e) {
                throw CliManagerUtils.createThrownException((Exception)((Object)e));
            }
        }
        finally {
            if (file != uploadFile) {
                ProcessingUnitUploadResourceCommand.deleteTempFile(uploadFile);
            }
        }
    }

    static File createTempZip(File directory) throws Exception {
        File workDir = new File(SystemInfo.singleton().locations().work());
        File tempDirectory = Files.createTempDirectory(workDir.toPath(), "temp-pu-", new FileAttribute[0]).toFile();
        File zipFile = new File(tempDirectory, directory.getName() + ".zip");
        System.out.println("Zipping folder [" + directory.getName() + "] into temp zip file [" + zipFile + "]");
        PUZipUtils.zip((File)directory, (File)zipFile);
        return zipFile;
    }

    static void deleteTempFile(File tempFile) {
        File tempDir = tempFile.getParentFile();
        if (!tempFile.delete()) {
            System.out.println("Warning: failed to delete temp file [" + tempFile + "]");
        }
        if (!tempDir.delete()) {
            System.out.println("Warning: failed to delete temp folder [" + tempDir + "]");
        }
    }

    public static enum Schema {
        partitioned,
        sync_replicated,
        async_replicated;

    }
}

