/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.space;

import com.gigaspaces.cli.commands.AbstractAsynchronousCommand;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.SpacesApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.Request;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gigaspaces.cli.CliCommandException;
import picocli.CommandLine;

@CommandLine.Command(name="demote-instance", header={"Demote a primary Space to backup"})
public class SpaceDemoteCommand
extends AbstractAsynchronousCommand {
    @CommandLine.Parameters(paramLabel="<instance ID>", index="0", description={"ID of Space instance to demote"})
    String spaceInstanceId;
    @CommandLine.Option(names={"--max-suspend-time"}, paramLabel="<max Suspend Time>", description={"Maximum suspend time of space during demote,\ne.g 15s"})
    String maxSuspendTime;
    private Set<String> deployedInstances = new HashSet<String>();

    @Override
    protected void execute() throws Exception {
        super.execute();
    }

    @Override
    protected void printSuccessfulResultMessage(Request responseData) {
        System.out.println("\nSpace instance [" + this.spaceInstanceId + "] was successfully demoted at " + responseData.getCompletedAt());
    }

    @Override
    protected ApiResponse<String> runAsyncRequest() throws ApiException {
        SpacesApi spacesApi = new SpacesApi();
        String spaceName = CliManagerUtils.retrieveSpaceName(this.spaceInstanceId);
        ApiResponse response = spacesApi.spacesIdInstancesInstanceIdDemotePostWithHttpInfo(spaceName, this.spaceInstanceId, this.maxSuspendTime);
        return response;
    }

    @Override
    protected boolean handleWaiting(Request request, ApiResponse<Request> getIdResponse, boolean forcePrintProgress) throws CliCommandException {
        if (System.currentTimeMillis() - this.startWaitingSuccessfulRequestTime > (long)(this.getWaitingTimeout() * 1000)) {
            return this.handleTimeout(request);
        }
        if (this.sleepCount % 5 == 0 || forcePrintProgress) {
            Request data = (Request)getIdResponse.getData();
            Map progressResult = data.getResult();
            if (progressResult != null) {
                Set resultEntries = progressResult.entrySet();
                boolean isFirst = false;
                for (Map.Entry entry : resultEntries) {
                    String value = (String)entry.getValue();
                    String key = (String)entry.getKey();
                    if (value == null || !value.equals("SUCCESS") || this.deployedInstances.contains(key)) continue;
                    if (!isFirst) {
                        System.out.println("");
                        isFirst = true;
                    }
                    System.out.println("Instance [" + key + "] successfully demoted");
                    this.deployedInstances.add(key);
                }
            }
            if (!forcePrintProgress) {
                System.out.print("\u00b7");
            }
        }
        return false;
    }
}

