/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.space;

import com.gigaspaces.cli.commands.AbstractAsynchronousCommand;
import com.gigaspaces.rest.client.java.api.SpacesApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.Request;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gigaspaces.cli.CliCommandException;
import picocli.CommandLine;

@CommandLine.Command(name="deploy", header={"Define a Space (data grid) for deployment"})
public class SpaceDeployCommand
extends AbstractAsynchronousCommand {
    @CommandLine.Parameters(index="0", description={"Name of Space to deploy"})
    String name;
    @CommandLine.Option(names={"--partitions"}, description={"Specify the number of partitions for the Space"})
    int partitions;
    @CommandLine.Option(names={"--ha"}, description={"High availability (add one backup per partition)"})
    boolean ha;
    @CommandLine.Option(names={"--requires-isolation"}, description={"Provision instances in a dedicated container"})
    boolean requiresIsolation;
    private Set<String> deployedInstances = new HashSet<String>();

    @Override
    protected void execute() throws Exception {
        this.validateOptions(this.partitions, this.ha);
        super.execute();
    }

    private void validateOptions(int partitions, boolean ha) throws CliCommandException {
        if (partitions == 0) {
            if (ha) {
                throw CliCommandException.userError((String)"Missing argument: '--partitions' when used in conjunction with '--ha' option");
            }
        } else if (partitions < 0) {
            throw CliCommandException.userError((String)("Illegal argument: '--partitions=" + partitions + "' must be positive"));
        }
    }

    @Override
    protected void printSuccessfulResultMessage(Request responseData) {
        String statusUrl = responseData.getStatusUrl();
        System.out.println("\nSpace [" + statusUrl.substring(statusUrl.lastIndexOf(47) + 1) + "] was successfully deployed at " + responseData.getCompletedAt());
    }

    @Override
    protected ApiResponse<String> runAsyncRequest() throws ApiException {
        SpacesApi spacesApi = new SpacesApi();
        ApiResponse response = spacesApi.spacesPostWithHttpInfo(this.name, Integer.valueOf(this.partitions), Boolean.valueOf(this.ha), Boolean.valueOf(this.requiresIsolation));
        return response;
    }

    @Override
    protected boolean handleWaiting(Request request, ApiResponse<Request> getIdResponse, boolean forcePrintProgress) throws CliCommandException {
        if (System.currentTimeMillis() - this.startWaitingSuccessfulRequestTime > (long)(this.getWaitingTimeout() * 1000)) {
            return this.handleTimeout(request);
        }
        if (this.sleepCount % 5 == 0 || forcePrintProgress) {
            Request data = (Request)getIdResponse.getData();
            Map progressResult = data.getResult();
            if (progressResult != null) {
                Set resultEntries = progressResult.entrySet();
                boolean isFirst = false;
                for (Map.Entry entry : resultEntries) {
                    String value = (String)entry.getValue();
                    String key = (String)entry.getKey();
                    if (value == null || !value.equals("SUCCESS") || this.deployedInstances.contains(key)) continue;
                    if (!isFirst) {
                        System.out.println("");
                        isFirst = true;
                    }
                    System.out.println("Instance [" + key + "] successfully deployed");
                    this.deployedInstances.add(key);
                }
            }
            if (!forcePrintProgress) {
                System.out.print("\u00b7");
            }
        }
        return false;
    }
}

