/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.space;

import com.gigaspaces.cli.commands.GigaSpacesRestCommand;
import com.gigaspaces.cli.commands.output.ConsoleOutput;
import com.gigaspaces.cli.commands.output.Output;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.SpacesApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.ProcessingUnitTopology;
import com.gigaspaces.rest.client.java.model.Space;
import com.gigaspaces.rest.client.java.model.SpaceOperationsStatistics;
import com.gigaspaces.rest.client.java.model.SpaceTypesStatistics;
import java.util.List;
import java.util.Set;
import picocli.CommandLine;

@CommandLine.Command(name="info", header={"Show information for the specified Space: operation statistics, data types"})
public class SpaceInfoCommand
extends GigaSpacesRestCommand {
    @CommandLine.Parameters(index="0", description={"Space name"})
    String name;
    @CommandLine.Option(names={"--operation-stats"}, description={"Show Space operations statistics"})
    boolean operationStats;
    @CommandLine.Option(names={"--type-stats"}, description={"Show Space data types statistics"})
    boolean typeStats;
    public static final String HEADER_SPACE_DETAILS = "SPACE DETAILS";
    public static final String HEADER_OPERATIONS_STATS = "OPERATIONS STATISTICS";
    public static final String HEADER_TYPES = "TYPES";

    protected void execute() throws Exception {
        block5: {
            try {
                SpacesApi spacesApi = new SpacesApi();
                ApiResponse spaceApiResponse = spacesApi.spacesIdGetWithHttpInfo(this.name);
                if (spaceApiResponse.getStatusCode() == 200) {
                    this.printSpaceDetails((ApiResponse<Space>)spaceApiResponse);
                    if (this.operationStats) {
                        ApiResponse spaceOperationsStatisticsApiResponse = spacesApi.spacesIdStatisticsOperationsGetWithHttpInfo(this.name);
                        this.printSpaceOperationsStatistics((ApiResponse<SpaceOperationsStatistics>)spaceOperationsStatisticsApiResponse);
                    }
                    if (this.typeStats) {
                        ApiResponse spaceTypesStatisticsApiResponse = spacesApi.spacesIdStatisticsTypesGetWithHttpInfo(this.name);
                        this.printSpaceTypes((ApiResponse<SpaceTypesStatistics>)spaceTypesStatisticsApiResponse);
                    }
                    break block5;
                }
                throw CliManagerUtils.getHttpFailureException(spaceApiResponse);
            }
            catch (ApiException e) {
                throw CliManagerUtils.createThrownException((Exception)((Object)e));
            }
        }
    }

    private void printSpaceDetails(ApiResponse<Space> spaceApiResponse) {
        Space data = (Space)spaceApiResponse.getData();
        String name = data.getName();
        String processingUnitName = data.getProcessingUnitName();
        ProcessingUnitTopology topology = data.getTopology();
        List instancesIds = data.getInstancesIds();
        Output output = new Output();
        output.addColumn(HEADER_SPACE_DETAILS);
        output.addRow("Space Name", name);
        output.addRow("Processing Unit Name", processingUnitName);
        output.addRow("Topology", CliManagerUtils.createTopologyPresentation(topology));
        output.addRow("Planned Instances", String.valueOf(CliManagerUtils.getPlannedInstances(topology)));
        output.addRow("Actual Instances", String.valueOf(instancesIds.size()));
        output.addRow("Instances", instancesIds.isEmpty() ? Output.EMPTY : (String)instancesIds.get(0));
        int instancesCount = instancesIds.size();
        for (int i = 1; i < instancesCount; ++i) {
            output.addRow(Output.EMPTY, (String)instancesIds.get(i));
        }
        ConsoleOutput.newline();
        ConsoleOutput.print(output);
    }

    private void printSpaceTypes(ApiResponse<SpaceTypesStatistics> spaceTypesStatisticsApiResponse) throws Exception {
        if (spaceTypesStatisticsApiResponse.getStatusCode() != 200) {
            throw CliManagerUtils.getHttpFailureException(spaceTypesStatisticsApiResponse);
        }
        SpaceTypesStatistics spaceTypesStatistics = (SpaceTypesStatistics)spaceTypesStatisticsApiResponse.getData();
        Set entries = spaceTypesStatistics.entrySet();
        CliManagerUtils.printSpaceTypeTable(HEADER_TYPES, entries);
    }

    private void printSpaceOperationsStatistics(ApiResponse<SpaceOperationsStatistics> operationsStatisticsApiResponse) throws Exception {
        if (operationsStatisticsApiResponse.getStatusCode() != 200) {
            throw CliManagerUtils.getHttpFailureException(operationsStatisticsApiResponse);
        }
        SpaceOperationsStatistics spaceOperationsStatistics = (SpaceOperationsStatistics)operationsStatisticsApiResponse.getData();
        Long objectCount = spaceOperationsStatistics.getObjectCount();
        Long notifyTemplateCount = spaceOperationsStatistics.getNotifyTemplateCount();
        Long activeConnectionCount = spaceOperationsStatistics.getActiveConnectionCount();
        Long activeTransactionCount = spaceOperationsStatistics.getActiveTransactionCount();
        Integer size = spaceOperationsStatistics.getSize();
        Long changeCount = spaceOperationsStatistics.getChangeCount();
        Double changePerSecond = spaceOperationsStatistics.getChangePerSecond();
        Long executeCount = spaceOperationsStatistics.getExecuteCount();
        Double executesPerSecond = spaceOperationsStatistics.getExecutesPerSecond();
        Long notifyAckCount = spaceOperationsStatistics.getNotifyAckCount();
        Double notifyAckPerSecond = spaceOperationsStatistics.getNotifyAckPerSecond();
        Long notifyRegistrationCount = spaceOperationsStatistics.getNotifyRegistrationCount();
        Double notifyRegistrationPerSecond = spaceOperationsStatistics.getNotifyRegistrationPerSecond();
        Long notifyTriggerCount = spaceOperationsStatistics.getNotifyTriggerCount();
        Double notifyTriggerPerSecond = spaceOperationsStatistics.getNotifyTriggerPerSecond();
        Long readCount = spaceOperationsStatistics.getReadCount();
        Double readPerSecond = spaceOperationsStatistics.getReadPerSecond();
        Long takeCount = spaceOperationsStatistics.getTakeCount();
        Double takePerSecond = spaceOperationsStatistics.getTakePerSecond();
        Long updateCount = spaceOperationsStatistics.getUpdateCount();
        Double updatePerSecond = spaceOperationsStatistics.getUpdatePerSecond();
        Long writeCount = spaceOperationsStatistics.getWriteCount();
        Double writePerSecond = spaceOperationsStatistics.getWritePerSecond();
        Output output = new Output();
        output.addColumn(HEADER_OPERATIONS_STATS);
        output.addRow("Objects Count", CliManagerUtils.formatLongValue(objectCount));
        output.addRow("Notify Templates Count", CliManagerUtils.formatLongValue(notifyTemplateCount));
        output.addRow("Active Connections Count", CliManagerUtils.formatLongValue(activeConnectionCount));
        output.addRow("Active Transactions Count", CliManagerUtils.formatLongValue(activeTransactionCount));
        output.addRow("Change Count", CliManagerUtils.formatLongValue(changeCount));
        output.addRow("Size", CliManagerUtils.formatLongValue(size.intValue()));
        output.addRow("Change per sec", CliManagerUtils.formatDecimalValue(changePerSecond));
        output.addRow("Execute Count", CliManagerUtils.formatLongValue(executeCount));
        output.addRow("Execute per sec", CliManagerUtils.formatDecimalValue(executesPerSecond));
        output.addRow("Notify Ack Count", CliManagerUtils.formatLongValue(notifyAckCount));
        output.addRow("Notify Ack per sec", CliManagerUtils.formatDecimalValue(notifyAckPerSecond));
        output.addRow("Notify Registr. Count", CliManagerUtils.formatLongValue(notifyRegistrationCount));
        output.addRow("Notify Registr. per sec", CliManagerUtils.formatDecimalValue(notifyRegistrationPerSecond));
        output.addRow("Notify Trigger Count", CliManagerUtils.formatLongValue(notifyTriggerCount));
        output.addRow("Notify Trigger per sec", CliManagerUtils.formatDecimalValue(notifyTriggerPerSecond));
        output.addRow("Read Count", CliManagerUtils.formatLongValue(readCount));
        output.addRow("Read per sec", CliManagerUtils.formatDecimalValue(readPerSecond));
        output.addRow("Take Count", CliManagerUtils.formatLongValue(takeCount));
        output.addRow("Take per sec", CliManagerUtils.formatDecimalValue(takePerSecond));
        output.addRow("Update Count", CliManagerUtils.formatLongValue(updateCount));
        output.addRow("Update per sec", CliManagerUtils.formatDecimalValue(updatePerSecond));
        output.addRow("Write Count", CliManagerUtils.formatLongValue(writeCount));
        output.addRow("Write per sec", CliManagerUtils.formatDecimalValue(writePerSecond));
        ConsoleOutput.newline();
        ConsoleOutput.print(output);
    }
}

