/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.space;

import com.gigaspaces.cli.commands.GigaSpacesRestCommand;
import com.gigaspaces.cli.commands.output.ConsoleOutput;
import com.gigaspaces.cli.commands.output.Output;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.SpacesApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.ReplicationChannelStatistics;
import com.gigaspaces.rest.client.java.model.ReplicationChannels;
import com.gigaspaces.rest.client.java.model.SpaceInstance;
import com.gigaspaces.rest.client.java.model.SpaceInstanceOperationsStatistics;
import com.gigaspaces.rest.client.java.model.SpaceInstanceReplicationStatistics;
import com.gigaspaces.rest.client.java.model.SpaceInstanceTypesStatistics;
import java.util.Map;
import java.util.Set;
import picocli.CommandLine;

@CommandLine.Command(name="info-instance", header={"Show information for the specified Space instance: mode, location"})
public class SpaceInfoInstanceCommand
extends GigaSpacesRestCommand {
    @CommandLine.Parameters(paramLabel="<instance ID>", index="0", description={"ID of the Space instance"})
    String instanceId;
    @CommandLine.Option(names={"--operation-stats"}, description={"Show Space instance operations statistics"})
    boolean operationStats;
    @CommandLine.Option(names={"--type-stats"}, description={"Show Space instance types statistics"})
    boolean typeStats;
    @CommandLine.Option(names={"--replication-stats"}, description={"Show Space instance replication statistics"})
    boolean replicationStats;
    public static final String HEADER_SPACE_INSTANCE_DETAILS = "SPACE INSTANCE DETAILS";
    public static final String HEADER_OPERATIONS_STATS = "OPERATIONS STATISTICS";
    public static final String HEADER_REPLICATION_STATS = "REPLICATION STATISTICS";
    public static final String HEADER_TYPES = "TYPES";

    protected void execute() throws Exception {
        block6: {
            try {
                SpacesApi spacesApi = new SpacesApi();
                String spaceName = CliManagerUtils.retrieveSpaceName(this.instanceId);
                ApiResponse spaceInstanceApiResponse = spacesApi.spacesIdInstancesInstanceIdGetWithHttpInfo(spaceName, this.instanceId);
                if (spaceInstanceApiResponse.getStatusCode() == 200) {
                    this.printSpaceInstanceDetails((ApiResponse<SpaceInstance>)spaceInstanceApiResponse);
                    if (this.operationStats) {
                        ApiResponse spaceInstanceOperationsStatisticsApiResponse = spacesApi.spacesIdInstancesInstanceIdStatisticsOperationsGetWithHttpInfo(spaceName, this.instanceId);
                        this.printSpaceOperationsStatistics((ApiResponse<SpaceInstanceOperationsStatistics>)spaceInstanceOperationsStatisticsApiResponse);
                    }
                    if (this.replicationStats) {
                        ApiResponse spaceInstanceReplicationStatisticsApiResponse = spacesApi.spacesIdInstancesInstanceIdStatisticsReplicationGetWithHttpInfo(spaceName, this.instanceId);
                        this.printSpaceInstanceReplcationStatistics((ApiResponse<SpaceInstanceReplicationStatistics>)spaceInstanceReplicationStatisticsApiResponse);
                    }
                    if (this.typeStats) {
                        ApiResponse spaceInstanceTypesStatisticsApiResponse = spacesApi.spacesIdInstancesInstanceIdStatisticsTypesGetWithHttpInfo(spaceName, this.instanceId);
                        this.printSpaceInstanceTypes((ApiResponse<SpaceInstanceTypesStatistics>)spaceInstanceTypesStatisticsApiResponse);
                    }
                    break block6;
                }
                throw CliManagerUtils.getHttpFailureException(spaceInstanceApiResponse);
            }
            catch (ApiException e) {
                throw CliManagerUtils.createThrownException((Exception)((Object)e));
            }
        }
    }

    private void printSpaceInstanceReplcationStatistics(ApiResponse<SpaceInstanceReplicationStatistics> spaceInstanceReplicationStatisticsApiResponse) throws Exception {
        Output output;
        if (spaceInstanceReplicationStatisticsApiResponse.getStatusCode() == 200) {
            SpaceInstanceReplicationStatistics spaceInstanceReplicationStatistics = (SpaceInstanceReplicationStatistics)spaceInstanceReplicationStatisticsApiResponse.getData();
            Long externalStoragePacketsCount = spaceInstanceReplicationStatistics.getExternalStoragePacketsCount();
            Long externalStorageSpaceUsed = spaceInstanceReplicationStatistics.getExternalStorageSpaceUsed();
            Long firstKeyInRedoLog = spaceInstanceReplicationStatistics.getFirstKeyInRedoLog();
            String printFirstKeyInRedoLog = CliManagerUtils.ifMinusOneReturnNA(firstKeyInRedoLog);
            Long lastConfirmedKey = spaceInstanceReplicationStatistics.getLastConfirmedKey();
            String printLastConfirmedKey = CliManagerUtils.ifMinusOneReturnNA(lastConfirmedKey);
            Long lastKeyInRedoLog = spaceInstanceReplicationStatistics.getLastKeyInRedoLog();
            String printLastKeyInRedoLog = CliManagerUtils.ifMinusOneReturnNA(lastKeyInRedoLog);
            Long memoryPacketsCount = spaceInstanceReplicationStatistics.getMemoryPacketsCount();
            Long redoLogSize = spaceInstanceReplicationStatistics.getRedoLogSize();
            ReplicationChannels channels = spaceInstanceReplicationStatistics.getChannels();
            output = new Output();
            output.addColumn(HEADER_REPLICATION_STATS);
            output.addRow("Objects Count", CliManagerUtils.formatLongValue(externalStoragePacketsCount));
            output.addRow("Notify Templates Count", CliManagerUtils.formatLongValue(externalStorageSpaceUsed));
            output.addRow("Active Connections Count", printFirstKeyInRedoLog);
            output.addRow("Active Transactions Count", printLastConfirmedKey);
            output.addRow("Change Count", printLastKeyInRedoLog);
            output.addRow("Change per sec", CliManagerUtils.formatLongValue(memoryPacketsCount));
            output.addRow("Execute Count", CliManagerUtils.formatLongValue(redoLogSize));
            if (channels != null && !channels.isEmpty()) {
                output.addRow("CHANNELS", Output.EMPTY);
                String replicationStatsPrefix = "   ";
                Set channelsEntries = channels.entrySet();
                for (Map.Entry channelEntry : channelsEntries) {
                    String key = (String)channelEntry.getKey();
                    ReplicationChannelStatistics replicationChannelStatistics = (ReplicationChannelStatistics)channelEntry.getValue();
                    ReplicationChannelStatistics.ChannelStateEnum channelState = replicationChannelStatistics.getChannelState();
                    ReplicationChannelStatistics.OperatingModeEnum operatingMode = replicationChannelStatistics.getOperatingMode();
                    ReplicationChannelStatistics.ReplicationModeEnum replicationMode = replicationChannelStatistics.getReplicationMode();
                    String inconsistencyReason = replicationChannelStatistics.getInconsistencyReason();
                    Long generatedTrafficBytes = replicationChannelStatistics.getGeneratedTrafficBytes();
                    Long generatedTrafficPerPacket = replicationChannelStatistics.getGeneratedTrafficPerPacket();
                    Long generatedTrafficTP = replicationChannelStatistics.getGeneratedTrafficTP();
                    Long lastConfirmedKeyFromTarget = replicationChannelStatistics.getLastConfirmedKeyFromTarget();
                    String printLastConfirmedKeyFromTarget = CliManagerUtils.ifMinusOneReturnNA(lastConfirmedKeyFromTarget);
                    Long lastKeyToReplicate = replicationChannelStatistics.getLastKeyToReplicate();
                    String printLastKeyToReplicate = CliManagerUtils.ifMinusOneReturnNA(lastKeyToReplicate);
                    Long receivedTrafficBytes = replicationChannelStatistics.getReceivedTrafficBytes();
                    Long receivedTrafficTP = replicationChannelStatistics.getReceivedTrafficTP();
                    Long redoLogRetainedWeight = replicationChannelStatistics.getRedologRetainedWeight();
                    Long redoLogRetainedSize = replicationChannelStatistics.getRedologRetainedSize();
                    Integer throughput = replicationChannelStatistics.getThroughput();
                    Long totalNumberOfReplicatedPackets = replicationChannelStatistics.getTotalNumberOfReplicatedPackets();
                    output.addRow(" [" + key + "]", Output.EMPTY);
                    output.addRow("   Channel State", String.valueOf(channelState));
                    output.addRow("   Operation Mode", String.valueOf(operatingMode));
                    output.addRow("   Replication Mode", String.valueOf(replicationMode));
                    if (inconsistencyReason != null) {
                        output.addRow("   Inconsistency Reason", inconsistencyReason);
                    }
                    output.addRow("   Generated Traffic Bytes", CliManagerUtils.formatLongValue(generatedTrafficBytes));
                    output.addRow("   Generated Traffic Per Packet", CliManagerUtils.formatLongValue(generatedTrafficPerPacket));
                    output.addRow("   Generated Traffic Throughput", CliManagerUtils.formatLongValue(generatedTrafficTP));
                    output.addRow("   Last Confirmed Key From Target", printLastConfirmedKeyFromTarget);
                    output.addRow("   Last Key To Replicate", printLastKeyToReplicate);
                    output.addRow("   Received Traffic Throughput", CliManagerUtils.formatLongValue(receivedTrafficTP));
                    output.addRow("   Redo Log Retained Weight", CliManagerUtils.formatLongValue(redoLogRetainedWeight));
                    output.addRow("   Redo Log Retained Size", CliManagerUtils.formatLongValue(redoLogRetainedSize));
                    output.addRow("   Throughput", CliManagerUtils.formatLongValue(throughput.intValue()));
                    output.addRow("   Total Num. Of Replicated Packets", CliManagerUtils.formatLongValue(totalNumberOfReplicatedPackets));
                }
            }
        } else {
            throw CliManagerUtils.getHttpFailureException(spaceInstanceReplicationStatisticsApiResponse);
        }
        ConsoleOutput.newline();
        ConsoleOutput.print(output);
    }

    private void printSpaceInstanceDetails(ApiResponse<SpaceInstance> spaceInstanceApiResponse) {
        SpaceInstance data = (SpaceInstance)spaceInstanceApiResponse.getData();
        String id = data.getId();
        String mode = data.getMode();
        String hostId = data.getHostId();
        String containerId = data.getContainerId();
        String suspendType = data.getSuspendInfo().getSuspendType().name();
        Output output = new Output();
        output.addColumn(HEADER_SPACE_INSTANCE_DETAILS);
        output.addRow("Space Instance ID", id);
        output.addRow("Mode", mode);
        output.addRow("Host ID", hostId);
        output.addRow("Container ID", containerId);
        output.addRow("Suspend Status", suspendType);
        ConsoleOutput.newline();
        ConsoleOutput.print(output);
    }

    private void printSpaceInstanceTypes(ApiResponse<SpaceInstanceTypesStatistics> spaceInstanceTypesStatisticsApiResponse) throws Exception {
        if (spaceInstanceTypesStatisticsApiResponse.getStatusCode() != 200) {
            throw CliManagerUtils.getHttpFailureException(spaceInstanceTypesStatisticsApiResponse);
        }
        SpaceInstanceTypesStatistics spaceInstanceTypesStatistics = (SpaceInstanceTypesStatistics)spaceInstanceTypesStatisticsApiResponse.getData();
        Set entries = spaceInstanceTypesStatistics.entrySet();
        CliManagerUtils.printSpaceTypeTable(HEADER_TYPES, entries);
    }

    private void printSpaceOperationsStatistics(ApiResponse<SpaceInstanceOperationsStatistics> spaceInstanceOperationsStatisticsApiResponse) throws Exception {
        if (spaceInstanceOperationsStatisticsApiResponse.getStatusCode() != 200) {
            throw CliManagerUtils.getHttpFailureException(spaceInstanceOperationsStatisticsApiResponse);
        }
        SpaceInstanceOperationsStatistics spaceInstanceOperationsStatistics = (SpaceInstanceOperationsStatistics)spaceInstanceOperationsStatisticsApiResponse.getData();
        Long objectCount = spaceInstanceOperationsStatistics.getObjectCount();
        Long notifyTemplateCount = spaceInstanceOperationsStatistics.getNotifyTemplateCount();
        Long activeConnectionCount = spaceInstanceOperationsStatistics.getActiveConnectionCount();
        String printActiveConnectionCount = CliManagerUtils.ifMinusOneReturnNA(activeConnectionCount);
        Long activeTransactionCount = spaceInstanceOperationsStatistics.getActiveTransactionCount();
        String printActiveTransactionCount = CliManagerUtils.ifMinusOneReturnNA(activeTransactionCount);
        Long changeCount = spaceInstanceOperationsStatistics.getChangeCount();
        Double changePerSecond = spaceInstanceOperationsStatistics.getChangePerSecond();
        Long executeCount = spaceInstanceOperationsStatistics.getExecuteCount();
        Double executesPerSecond = spaceInstanceOperationsStatistics.getExecutesPerSecond();
        Long notifyAckCount = spaceInstanceOperationsStatistics.getNotifyAckCount();
        Double notifyAckPerSecond = spaceInstanceOperationsStatistics.getNotifyAckPerSecond();
        Long notifyRegistrationCount = spaceInstanceOperationsStatistics.getNotifyRegistrationCount();
        Double notifyRegistrationPerSecond = spaceInstanceOperationsStatistics.getNotifyRegistrationPerSecond();
        Long notifyTriggerCount = spaceInstanceOperationsStatistics.getNotifyTriggerCount();
        Double notifyTriggerPerSecond = spaceInstanceOperationsStatistics.getNotifyTriggerPerSecond();
        Long readCount = spaceInstanceOperationsStatistics.getReadCount();
        Double readPerSecond = spaceInstanceOperationsStatistics.getReadPerSecond();
        Long takeCount = spaceInstanceOperationsStatistics.getTakeCount();
        Double takePerSecond = spaceInstanceOperationsStatistics.getTakePerSecond();
        Long updateCount = spaceInstanceOperationsStatistics.getUpdateCount();
        Double updatePerSecond = spaceInstanceOperationsStatistics.getUpdatePerSecond();
        Long writeCount = spaceInstanceOperationsStatistics.getWriteCount();
        Double writePerSecond = spaceInstanceOperationsStatistics.getWritePerSecond();
        Output output = new Output();
        output.addColumn(HEADER_OPERATIONS_STATS);
        output.addRow("Objects Count", CliManagerUtils.formatLongValue(objectCount));
        output.addRow("Notify Templates Count", CliManagerUtils.formatLongValue(notifyTemplateCount));
        output.addRow("Active Connections Count", printActiveConnectionCount);
        output.addRow("Active Transactions Count", printActiveTransactionCount);
        output.addRow("Change Count", CliManagerUtils.formatLongValue(changeCount));
        output.addRow("Change per sec", CliManagerUtils.formatDecimalValue(changePerSecond));
        output.addRow("Execute Count", CliManagerUtils.formatLongValue(executeCount));
        output.addRow("Execute per sec", CliManagerUtils.formatDecimalValue(executesPerSecond));
        output.addRow("Notify Ack Count", CliManagerUtils.formatLongValue(notifyAckCount));
        output.addRow("Notify Ack per sec", CliManagerUtils.formatDecimalValue(notifyAckPerSecond));
        output.addRow("Notify Registr. Count", CliManagerUtils.formatLongValue(notifyRegistrationCount));
        output.addRow("Notify Registr. per sec", CliManagerUtils.formatDecimalValue(notifyRegistrationPerSecond));
        output.addRow("Notify Trigger Count", CliManagerUtils.formatLongValue(notifyTriggerCount));
        output.addRow("Notify Trigger per sec", CliManagerUtils.formatDecimalValue(notifyTriggerPerSecond));
        output.addRow("Read Count", CliManagerUtils.formatLongValue(readCount));
        output.addRow("Read per sec", CliManagerUtils.formatDecimalValue(readPerSecond));
        output.addRow("Take Count", CliManagerUtils.formatLongValue(takeCount));
        output.addRow("Take per sec", CliManagerUtils.formatDecimalValue(takePerSecond));
        output.addRow("Update Count", CliManagerUtils.formatLongValue(updateCount));
        output.addRow("Update per sec", CliManagerUtils.formatDecimalValue(updatePerSecond));
        output.addRow("Write Count", CliManagerUtils.formatLongValue(writeCount));
        output.addRow("Write per sec", CliManagerUtils.formatDecimalValue(writePerSecond));
        ConsoleOutput.newline();
        ConsoleOutput.print(output);
    }
}

