/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.space;

import com.gigaspaces.cli.commands.GigaSpacesRestCommand;
import com.gigaspaces.cli.commands.output.ConsoleOutput;
import com.gigaspaces.cli.commands.output.Output;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.SpacesApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.Space;
import java.util.List;
import java.util.logging.Level;
import picocli.CommandLine;

@CommandLine.Command(name="list", header={"List the deployed Spaces"})
public class SpaceListCommand
extends GigaSpacesRestCommand {
    private static final String[] headersList = new String[]{"Space Name", "Processing Unit Name", "Topology", "Actual/Planned Inst.", "Instances ID"};

    protected void execute() throws Exception {
        try {
            int totalPlanned;
            int totalActual;
            Output output;
            List responseData;
            ApiResponse response = new SpacesApi().spacesGetWithHttpInfo();
            if (response.getStatusCode() == 200) {
                responseData = (List)response.getData();
                output = new Output();
                output.addColumns(headersList);
                totalActual = 0;
                totalPlanned = 0;
                for (Space space : responseData) {
                    String firstInstanceId;
                    List instancesIds = space.getInstancesIds();
                    String string = firstInstanceId = instancesIds.isEmpty() ? Output.EMPTY : (String)instancesIds.get(0);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Space [" + space.getName() + "] has " + instancesIds.size() + "  space instances");
                    }
                    int actualInstances = space.getInstancesIds().size();
                    int plannedInstances = CliManagerUtils.getPlannedInstances(space.getTopology());
                    output.addRow(space.getName(), space.getProcessingUnitName(), CliManagerUtils.createTopologyPresentation(space.getTopology()), actualInstances + "/" + plannedInstances, firstInstanceId);
                    for (int i = 1; i < instancesIds.size(); ++i) {
                        output.addRow(Output.EMPTY, Output.EMPTY, Output.EMPTY, Output.EMPTY, (String)instancesIds.get(i));
                    }
                    totalActual += actualInstances;
                    totalPlanned += plannedInstances;
                }
            } else {
                throw CliManagerUtils.getHttpFailureException(response);
            }
            ConsoleOutput.newline();
            ConsoleOutput.println(output);
            Output sumOutput = new Output();
            sumOutput.addColumn("SUMMARY");
            sumOutput.addRow("Spaces:", String.valueOf(responseData.size())).addRow("Actual:", String.valueOf(totalActual)).addRow("Planned:", String.valueOf(totalPlanned));
            ConsoleOutput.newline();
            ConsoleOutput.println(sumOutput);
        }
        catch (ApiException e) {
            throw CliManagerUtils.createThrownException((Exception)((Object)e));
        }
    }
}

